/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.ConnectionTimeouts;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.TlsProtocols;
import org.apache.pinot.client.utils.ConnectionUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.ClientStats;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAsyncHttpPinotClientTransport
implements PinotClientTransport<ClientStats> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonAsyncHttpPinotClientTransport.class);
    private static final ObjectReader OBJECT_READER = JsonUtils.DEFAULT_READER;
    private static final String DEFAULT_EXTRA_QUERY_OPTION_STRING = "groupByMode=sql;responseFormat=sql";
    private final Map<String, String> _headers;
    private final String _scheme;
    private final int _brokerReadTimeout;
    private final AsyncHttpClient _httpClient;
    private final String _extraOptionStr;
    private final boolean _useMultistageEngine;

    public JsonAsyncHttpPinotClientTransport() {
        this._brokerReadTimeout = 60000;
        this._headers = new HashMap<String, String>();
        this._scheme = "http";
        this._extraOptionStr = DEFAULT_EXTRA_QUERY_OPTION_STRING;
        this._httpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(Duration.ofMillis(this._brokerReadTimeout)));
        this._useMultistageEngine = false;
    }

    public JsonAsyncHttpPinotClientTransport(Map<String, String> headers, String scheme, String extraOptionString, boolean useMultistageEngine, @Nullable SSLContext sslContext, ConnectionTimeouts connectionTimeouts, TlsProtocols tlsProtocols, @Nullable String appId) {
        this._brokerReadTimeout = connectionTimeouts.getReadTimeoutMs();
        this._headers = headers;
        this._scheme = scheme;
        this._extraOptionStr = StringUtils.isEmpty((CharSequence)extraOptionString) ? DEFAULT_EXTRA_QUERY_OPTION_STRING : extraOptionString;
        this._useMultistageEngine = useMultistageEngine;
        DefaultAsyncHttpClientConfig.Builder builder = Dsl.config();
        if (sslContext != null) {
            builder.setSslContext((SslContext)new JdkSslContext(sslContext, true, ClientAuth.OPTIONAL));
        }
        builder.setRequestTimeout(Duration.ofMillis(this._brokerReadTimeout)).setReadTimeout(Duration.ofMillis(connectionTimeouts.getReadTimeoutMs())).setConnectTimeout(Duration.ofMillis(connectionTimeouts.getConnectTimeoutMs())).setHandshakeTimeout(connectionTimeouts.getHandshakeTimeoutMs()).setUserAgent(ConnectionUtils.getUserAgentVersionFromClassPath("ua", appId)).setEnabledProtocols(tlsProtocols.getEnabledProtocols().toArray(new String[0]));
        this._httpClient = Dsl.asyncHttpClient((AsyncHttpClientConfig)builder.build());
    }

    @Override
    public BrokerResponse executeQuery(String brokerAddress, String query) throws PinotClientException {
        try {
            return this.executeQueryAsync(brokerAddress, query).get(this._brokerReadTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @Override
    public CompletableFuture<BrokerResponse> executeQueryAsync(String brokerAddress, String query) {
        try {
            ObjectNode json = JsonNodeFactory.instance.objectNode();
            json.put("sql", query);
            json.put("queryOptions", this._extraOptionStr);
            LOGGER.debug("Query will use Multistage Engine = {}", (Object)this._useMultistageEngine);
            String url = String.format("%s://%s%s", this._scheme, brokerAddress, this._useMultistageEngine ? "/query" : "/query/sql");
            BoundRequestBuilder requestBuilder = this._httpClient.preparePost(url);
            if (this._headers != null) {
                this._headers.forEach((k, v) -> requestBuilder.addHeader((CharSequence)k, v));
            }
            LOGGER.debug("Sending query {} to {}", (Object)query, (Object)url);
            return ((BoundRequestBuilder)((BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).setBody(json.toString())).execute().toCompletableFuture().thenApply(httpResponse -> {
                LOGGER.debug("Completed query, HTTP status is {}", (Object)httpResponse.getStatusCode());
                if (httpResponse.getStatusCode() != 200) {
                    throw new PinotClientException("Pinot returned HTTP status " + httpResponse.getStatusCode() + ", expected 200");
                }
                try {
                    return BrokerResponse.fromJson(OBJECT_READER.readTree(httpResponse.getResponseBodyAsStream()));
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @Override
    public void close() throws PinotClientException {
        if (this._httpClient.isClosed()) {
            throw new PinotClientException("Connection is already closed!");
        }
        try {
            this._httpClient.close();
        }
        catch (IOException exception) {
            throw new PinotClientException("Error while closing connection!");
        }
    }

    @Override
    public ClientStats getClientMetrics() {
        return this._httpClient.getClientStats();
    }
}

