/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.List;
import java.util.Properties;
import org.apache.pinot.client.BrokerCacheUpdaterPeriodic;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.UpdatableBrokerCache;

public class ControllerBasedBrokerSelector
implements BrokerSelector {
    private static final String SCHEME = "scheme";
    private final UpdatableBrokerCache _brokerCache;
    private final Properties _properties;

    public ControllerBasedBrokerSelector(String scheme, String controllerHost, int controllerPort) throws Exception {
        this(scheme, controllerHost, controllerPort, new Properties());
    }

    public ControllerBasedBrokerSelector(String scheme, String controllerHost, int controllerPort, Properties properties) throws Exception {
        this._properties = properties;
        String controllerUrl = controllerHost + ":" + controllerPort;
        this._properties.setProperty(SCHEME, scheme);
        this._brokerCache = new BrokerCacheUpdaterPeriodic(this._properties, controllerUrl);
        this._brokerCache.init();
    }

    public ControllerBasedBrokerSelector(Properties properties, String controllerUrl) throws Exception {
        this._properties = properties;
        this._brokerCache = new BrokerCacheUpdaterPeriodic(properties, controllerUrl);
        this._brokerCache.init();
    }

    @Override
    public String selectBroker(String ... tableNames) {
        return this._brokerCache.getBroker(tableNames);
    }

    @Override
    public List<String> getBrokers() {
        return this._brokerCache.getBrokers();
    }

    @Override
    public void close() {
        this._brokerCache.close();
    }

    public void updateBrokers() throws Exception {
        this._brokerCache.triggerBrokerCacheUpdate();
    }
}

