/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.I0Itec.zkclient.ZkClient;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalViewReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalViewReader.class);
    private static final ObjectReader OBJECT_READER = JsonUtils.DEFAULT_READER;
    public static final String BROKER_EXTERNAL_VIEW_PATH = "/EXTERNALVIEW/brokerResource";
    public static final String BROKER_INSTANCE_PATH = "/CONFIGS/PARTICIPANT";
    public static final String REALTIME_SUFFIX = "_REALTIME";
    public static final String OFFLINE_SUFFIX = "_OFFLINE";
    public static final String KEY_PINOT_TLS_PORT = "PINOT_TLS_PORT";
    public static final String KEY_SIMPLE_FIELDS = "simpleFields";
    public static final String KEY_HELIX_HOST = "HELIX_HOST";
    public static final String KEY_HELIX_PORT = "HELIX_PORT";
    private ZkClient _zkClient;
    @VisibleForTesting
    boolean _preferTlsPort;

    public ExternalViewReader(ZkClient zkClient, boolean preferTlsPort) {
        this._preferTlsPort = preferTlsPort;
        this._zkClient = zkClient;
    }

    public ExternalViewReader(ZkClient zkClient) {
        this(zkClient, false);
    }

    public List<String> getLiveBrokers() {
        ArrayList<String> brokerUrls = new ArrayList<String>();
        try {
            byte[] brokerResourceNodeData = (byte[])this._zkClient.readData(BROKER_EXTERNAL_VIEW_PATH, true);
            brokerResourceNodeData = ExternalViewReader.unpackZnodeIfNecessary(brokerResourceNodeData);
            JsonNode jsonObject = OBJECT_READER.readTree((InputStream)this.getInputStream(brokerResourceNodeData));
            JsonNode brokerResourceNode = jsonObject.get("mapFields");
            Iterator resourceEntries = brokerResourceNode.fields();
            while (resourceEntries.hasNext()) {
                JsonNode resource = (JsonNode)((Map.Entry)resourceEntries.next()).getValue();
                Iterator brokerEntries = resource.fields();
                while (brokerEntries.hasNext()) {
                    Map.Entry brokerEntry = (Map.Entry)brokerEntries.next();
                    String brokerName = (String)brokerEntry.getKey();
                    if (!brokerName.startsWith("Broker_") || !"ONLINE".equals(((JsonNode)brokerEntry.getValue()).asText())) continue;
                    brokerUrls.add(this.getHostPort(brokerName));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading External view from zookeeper", (Throwable)e);
        }
        return brokerUrls;
    }

    @VisibleForTesting
    String getHostPort(String brokerName) {
        try {
            JsonNode simpleFields;
            JsonNode record;
            byte[] znStrBytes = (byte[])this._zkClient.readData("/CONFIGS/PARTICIPANT/" + brokerName, true);
            if (znStrBytes != null && (record = OBJECT_READER.readTree(new String(znStrBytes, StandardCharsets.UTF_8))) != null && (simpleFields = record.get(KEY_SIMPLE_FIELDS)) != null) {
                JsonNode hostNameNode = simpleFields.get(KEY_HELIX_HOST);
                JsonNode tlsPortNode = simpleFields.get(KEY_PINOT_TLS_PORT);
                JsonNode helixPortNode = simpleFields.get(KEY_HELIX_PORT);
                String[] splitItems = brokerName.split("_");
                if (splitItems.length < 3) {
                    throw new RuntimeException("Wrong BrokerName format " + brokerName);
                }
                String hostName = splitItems[1];
                if (hostNameNode != null && !Strings.isNullOrEmpty((String)hostNameNode.asText())) {
                    hostName = hostNameNode.asText();
                }
                if (tlsPortNode != null && !Strings.isNullOrEmpty((String)tlsPortNode.asText()) && this._preferTlsPort) {
                    return hostName + ":" + tlsPortNode.asText();
                }
                if (helixPortNode != null && !Strings.isNullOrEmpty((String)helixPortNode.asText())) {
                    return hostName + ":" + helixPortNode.asText();
                }
                return hostName + ":" + splitItems[splitItems.length - 1];
            }
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Failed to read broker instance config for {}. Return by naming convention", (Object)brokerName, (Object)ex);
        }
        return brokerName.replace("Broker_", "").replace("_", ":");
    }

    protected ByteArrayInputStream getInputStream(byte[] brokerResourceNodeData) {
        return new ByteArrayInputStream(brokerResourceNodeData);
    }

    public Map<String, List<String>> getTableToBrokersMap() {
        HashMap<String, Set> brokerUrlsMap = new HashMap<String, Set>();
        try {
            byte[] brokerResourceNodeData = (byte[])this._zkClient.readData(BROKER_EXTERNAL_VIEW_PATH, true);
            brokerResourceNodeData = ExternalViewReader.unpackZnodeIfNecessary(brokerResourceNodeData);
            JsonNode jsonObject = OBJECT_READER.readTree((InputStream)this.getInputStream(brokerResourceNodeData));
            JsonNode brokerResourceNode = jsonObject.get("mapFields");
            Iterator resourceEntries = brokerResourceNode.fields();
            while (resourceEntries.hasNext()) {
                Map.Entry resourceEntry = (Map.Entry)resourceEntries.next();
                String resourceName = (String)resourceEntry.getKey();
                String tableName = resourceName.replace(OFFLINE_SUFFIX, "").replace(REALTIME_SUFFIX, "");
                Set brokerUrls = brokerUrlsMap.computeIfAbsent(tableName, k -> new HashSet());
                JsonNode resource = (JsonNode)resourceEntry.getValue();
                Iterator brokerEntries = resource.fields();
                while (brokerEntries.hasNext()) {
                    Map.Entry brokerEntry = (Map.Entry)brokerEntries.next();
                    String brokerName = (String)brokerEntry.getKey();
                    if (!brokerName.startsWith("Broker_") || !"ONLINE".equals(((JsonNode)brokerEntry.getValue()).asText())) continue;
                    brokerUrls.add(this.getHostPort(brokerName));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading External view from zookeeper", (Throwable)e);
        }
        HashMap<String, List<String>> tableToBrokersMap = new HashMap<String, List<String>>();
        for (Map.Entry entry : brokerUrlsMap.entrySet()) {
            tableToBrokersMap.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return tableToBrokersMap;
    }

    private static byte[] unpackZnodeIfNecessary(byte[] znodeContents) {
        if (znodeContents[0] == 31 && znodeContents[1] == -117) {
            try {
                GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(znodeContents));
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                int byteRead = inputStream.read();
                while (byteRead != -1) {
                    outputStream.write(byteRead);
                    byteRead = inputStream.read();
                }
                return outputStream.toByteArray();
            }
            catch (IOException e) {
                LOGGER.error("Failed to decompress znode contents", (Throwable)e);
                return znodeContents;
            }
        }
        return znodeContents;
    }
}

