/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.http;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.SimpleHttpErrorInfo;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.common.utils.TarCompressionUtils;
import org.apache.pinot.common.utils.http.HttpClientConfig;
import org.apache.pinot.common.utils.tls.TlsUtils;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 600000;
    public static final int GET_REQUEST_SOCKET_TIMEOUT_MS = 5000;
    public static final int DELETE_REQUEST_SOCKET_TIMEOUT_MS = 10000;
    public static final String AUTH_HTTP_HEADER = "Authorization";
    public static final String JSON_CONTENT_TYPE = "application/json";
    private final CloseableHttpClient _httpClient;

    public HttpClient() {
        this(HttpClientConfig.DEFAULT_HTTP_CLIENT_CONFIG, null);
    }

    public HttpClient(@Nullable SSLContext sslContext) {
        this(HttpClientConfig.DEFAULT_HTTP_CLIENT_CONFIG, sslContext);
    }

    public HttpClient(HttpClientConfig httpClientConfig, @Nullable SSLContext sslContext) {
        SSLContext context = sslContext != null ? sslContext : TlsUtils.getSslContext();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        this._httpClient = HttpClient.buildCloseableHttpClient(httpClientConfig, csf);
    }

    public static HttpClient getInstance() {
        return HttpClientHolder.HTTP_CLIENT;
    }

    public SimpleHttpResponse sendGetRequest(URI uri) throws IOException {
        return this.sendGetRequest(uri, null, null);
    }

    public SimpleHttpResponse sendGetRequest(URI uri, @Nullable Map<String, String> headers) throws IOException {
        return this.sendGetRequest(uri, headers, null);
    }

    public SimpleHttpResponse sendGetRequest(URI uri, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((ClassicRequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return this.sendRequest(requestBuilder.build(), 5000L);
    }

    public SimpleHttpResponse sendDeleteRequest(URI uri) throws IOException {
        return this.sendDeleteRequest(uri, Collections.emptyMap());
    }

    public SimpleHttpResponse sendDeleteRequest(URI uri, @Nullable Map<String, String> headers) throws IOException {
        return this.sendDeleteRequest(uri, headers, null);
    }

    public SimpleHttpResponse sendDeleteRequest(URI uri, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.delete((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((ClassicRequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return this.sendRequest(requestBuilder.build(), 10000L);
    }

    public SimpleHttpResponse sendPostRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers) throws IOException {
        return this.sendPostRequest(uri, payload, headers, null);
    }

    public SimpleHttpResponse sendPostRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        if (payload != null) {
            requestBuilder.setEntity(payload);
        }
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((ClassicRequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return this.sendRequest(requestBuilder.build(), 600000L);
    }

    public SimpleHttpResponse sendPutRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers) throws IOException {
        return this.sendPutRequest(uri, payload, headers, null);
    }

    public SimpleHttpResponse sendPutRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.put((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        if (payload != null) {
            requestBuilder.setEntity(payload);
        }
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((ClassicRequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return this.sendRequest(requestBuilder.build(), 10000L);
    }

    public SimpleHttpResponse sendJsonPostRequest(URI uri, @Nullable String jsonRequestBody) throws IOException {
        return this.sendJsonPostRequest(uri, jsonRequestBody, null);
    }

    public SimpleHttpResponse sendJsonPostRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers) throws IOException {
        return this.sendJsonPostRequest(uri, jsonRequestBody, headers, null);
    }

    public SimpleHttpResponse sendJsonPostRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        HashMap<String, String> headersWrapper = MapUtils.isEmpty(headers) ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        headersWrapper.put("Content-Type", JSON_CONTENT_TYPE);
        StringEntity entity = jsonRequestBody == null ? null : new StringEntity(jsonRequestBody, ContentType.APPLICATION_JSON);
        return this.sendPostRequest(uri, (HttpEntity)entity, headers, authProvider);
    }

    public SimpleHttpResponse sendJsonPutRequest(URI uri, @Nullable String jsonRequestBody) throws IOException {
        return this.sendJsonPutRequest(uri, jsonRequestBody, null);
    }

    public SimpleHttpResponse sendJsonPutRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers) throws IOException {
        return this.sendJsonPutRequest(uri, jsonRequestBody, headers, null);
    }

    public SimpleHttpResponse sendJsonPutRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        HashMap<String, String> headersWrapper = MapUtils.isEmpty(headers) ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        headersWrapper.put("Content-Type", JSON_CONTENT_TYPE);
        StringEntity entity = jsonRequestBody == null ? null : new StringEntity(jsonRequestBody, ContentType.APPLICATION_JSON);
        return this.sendPutRequest(uri, (HttpEntity)entity, headersWrapper, authProvider);
    }

    public SimpleHttpResponse sendRequest(ClassicHttpRequest request) throws IOException {
        return this.sendRequest(request, 600000L);
    }

    public SimpleHttpResponse sendRequest(ClassicHttpRequest request, long socketTimeoutMs) throws IOException {
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)socketTimeoutMs)).build();
        HttpClientContext clientContext = HttpClientContext.create();
        clientContext.setRequestConfig(requestConfig);
        try (CloseableHttpResponse response = this._httpClient.execute(request, (HttpContext)clientContext);){
            SimpleHttpResponse simpleHttpResponse;
            int statusCode;
            if (response.containsHeader("Pinot-Controller-Host")) {
                String controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
                String controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
                LOGGER.info("Sending request: {} to controller: {}, version: {}", new Object[]{request.getRequestUri(), controllerHost, controllerVersion});
            }
            if ((statusCode = response.getCode()) >= 300) {
                simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.getErrorMessage(request, response));
                return simpleHttpResponse;
            }
            simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.httpEntityToString(response.getEntity()));
            return simpleHttpResponse;
        }
    }

    public CloseableHttpResponse execute(ClassicHttpRequest request) throws IOException {
        return this._httpClient.execute(request);
    }

    public SimpleHttpResponse sendMultipartPostRequest(String url, String body) throws IOException {
        return this.sendMultipartPostRequest(url, body, null);
    }

    public SimpleHttpResponse sendMultipartPostRequest(String url, String body, @Nullable Map<String, String> headers) throws IOException {
        HttpPost post = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("body", body);
        post.setEntity(builder.build());
        if (MapUtils.isNotEmpty(headers)) {
            for (String key : headers.keySet()) {
                post.addHeader(key, (Object)headers.get(key));
            }
        }
        try (CloseableHttpResponse response = this._httpClient.execute((ClassicHttpRequest)post);){
            int statusCode = response.getCode();
            if (statusCode >= 300) {
                SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.getErrorMessage((ClassicHttpRequest)post, response));
                return simpleHttpResponse;
            }
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.httpEntityToString(response.getEntity()));
            return simpleHttpResponse;
        }
    }

    private static String httpEntityToString(HttpEntity httpEntity) throws IOException {
        try {
            return EntityUtils.toString((HttpEntity)httpEntity);
        }
        catch (ParseException exception) {
            throw new RuntimeException(exception);
        }
    }

    public SimpleHttpResponse sendMultipartPutRequest(String url, String body) throws IOException {
        return this.sendMultipartPutRequest(url, body, null);
    }

    public SimpleHttpResponse sendMultipartPutRequest(String url, String body, @Nullable Map<String, String> headers) throws IOException {
        HttpPut put = new HttpPut(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("body", body);
        put.setEntity(builder.build());
        if (MapUtils.isNotEmpty(headers)) {
            for (String key : headers.keySet()) {
                put.addHeader(key, (Object)headers.get(key));
            }
        }
        try (CloseableHttpResponse response = this._httpClient.execute((ClassicHttpRequest)put);){
            int statusCode = response.getCode();
            if (statusCode >= 300) {
                SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.getErrorMessage((ClassicHttpRequest)put, response));
                return simpleHttpResponse;
            }
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.httpEntityToString(response.getEntity()));
            return simpleHttpResponse;
        }
    }

    public int downloadFile(URI uri, int socketTimeoutMs, File dest, AuthProvider authProvider, List<Header> httpHeaders) throws IOException, HttpErrorStatusException {
        ClassicHttpRequest request = HttpClient.getDownloadFileRequest(uri, authProvider, httpHeaders);
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)socketTimeoutMs)).build();
        HttpClientContext clientContext = HttpClientContext.create();
        clientContext.setRequestConfig(requestConfig);
        try (CloseableHttpResponse response = this._httpClient.execute(request, (HttpContext)clientContext);){
            int statusCode = response.getCode();
            if (statusCode >= 300) {
                throw new HttpErrorStatusException(HttpClient.getErrorMessage(request, response), statusCode);
            }
            HttpEntity entity = response.getEntity();
            try (InputStream inputStream = response.getEntity().getContent();
                 BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dest));){
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            }
            long contentLength = entity.getContentLength();
            if (contentLength >= 0L) {
                long fileLength = dest.length();
                Preconditions.checkState((fileLength == contentLength ? 1 : 0) != 0, (Object)String.format("While downloading file with uri: %s, file length: %d does not match content length: %d", uri, fileLength, contentLength));
            }
            int n = statusCode;
            return n;
        }
    }

    public File downloadUntarFileStreamed(URI uri, int socketTimeoutMs, File dest, AuthProvider authProvider, List<Header> httpHeaders, long maxStreamRateInByte) throws IOException, HttpErrorStatusException {
        ClassicHttpRequest request = HttpClient.getDownloadFileRequest(uri, authProvider, httpHeaders);
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)socketTimeoutMs)).build();
        HttpClientContext clientContext = HttpClientContext.create();
        clientContext.setRequestConfig(requestConfig);
        try (CloseableHttpResponse response = this._httpClient.execute(request, (HttpContext)clientContext);){
            File ret;
            int statusCode = response.getCode();
            if (statusCode >= 300) {
                throw new HttpErrorStatusException(HttpClient.getErrorMessage(request, response), statusCode);
            }
            try (InputStream inputStream = response.getEntity().getContent();){
                ret = TarCompressionUtils.untarWithRateLimiter(inputStream, dest, maxStreamRateInByte).get(0);
            }
            LOGGER.info("Downloaded from: {} to: {} with rate limiter; Response status code: {}", new Object[]{uri, dest, statusCode});
            File file = ret;
            return file;
        }
    }

    public static SimpleHttpResponse wrapAndThrowHttpException(SimpleHttpResponse resp) throws HttpErrorStatusException {
        if (resp.getStatusCode() >= 300) {
            throw new HttpErrorStatusException(resp.getResponse(), resp.getStatusCode());
        }
        return resp;
    }

    public static void addHeadersAndParameters(ClassicRequestBuilder requestBuilder, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) {
        if (headers != null) {
            for (Header header : headers) {
                requestBuilder.addHeader(header);
            }
        }
        if (parameters != null) {
            for (NameValuePair parameter : parameters) {
                requestBuilder.addParameter(parameter);
            }
        }
    }

    private static CloseableHttpClient buildCloseableHttpClient(HttpClientConfig httpClientConfig, SSLConnectionSocketFactory csf) {
        PoolingHttpClientConnectionManager connManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).setMaxConnTotal(httpClientConfig.getMaxConnTotal()).setMaxConnPerRoute(httpClientConfig.getMaxConnPerRoute()).build();
        if (httpClientConfig.getMaxConnTotal() > 0) {
            connManager.setMaxTotal(httpClientConfig.getMaxConnTotal());
        }
        if (httpClientConfig.getMaxConnPerRoute() > 0) {
            connManager.setDefaultMaxPerRoute(httpClientConfig.getMaxConnPerRoute());
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        if (httpClientConfig.isDisableDefaultUserAgent()) {
            httpClientBuilder.disableDefaultUserAgent();
        }
        return httpClientBuilder.build();
    }

    private static String getErrorMessage(ClassicHttpRequest request, CloseableHttpResponse response) {
        String reason;
        String controllerHost = null;
        String controllerVersion = null;
        if (response.containsHeader("Pinot-Controller-Host")) {
            controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
            controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
        }
        try {
            String entityStr = EntityUtils.toString((HttpEntity)response.getEntity());
            try {
                reason = ((SimpleHttpErrorInfo)JsonUtils.stringToObject((String)entityStr, SimpleHttpErrorInfo.class)).getError();
            }
            catch (Exception e) {
                reason = entityStr;
            }
        }
        catch (Exception e) {
            reason = String.format("Failed to get a reason, exception: %s", e);
        }
        String errorMessage = String.format("Got error status code: %d (%s) with reason: \"%s\" while sending request: %s", response.getCode(), response.getReasonPhrase(), reason, request.getRequestUri());
        if (controllerHost != null) {
            errorMessage = String.format("%s to controller: %s, version: %s", errorMessage, controllerHost, controllerVersion);
        }
        return errorMessage;
    }

    private static ClassicHttpRequest getDownloadFileRequest(URI uri, AuthProvider authProvider, List<Header> httpHeaders) {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((ClassicRequestBuilder)requestBuilder).addHeader(arg_0));
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String encoded = Base64.encodeBase64String((byte[])userInfo.getBytes(StandardCharsets.UTF_8));
            String authHeader = "Basic " + encoded;
            requestBuilder.addHeader(AUTH_HTTP_HEADER, authHeader);
        }
        if (httpHeaders != null && !httpHeaders.isEmpty()) {
            for (Header header : httpHeaders) {
                requestBuilder.addHeader(header);
            }
        }
        return requestBuilder.build();
    }

    @Override
    public void close() throws IOException {
        this._httpClient.close();
    }

    private static final class HttpClientHolder {
        static final HttpClient HTTP_CLIENT = new HttpClient(HttpClientConfig.DEFAULT_HTTP_CLIENT_CONFIG, TlsUtils.getSslContext());

        private HttpClientHolder() {
        }
    }
}

