/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.zookeeper.data.Stat;

public class FakePropertyStore
extends ZkHelixPropertyStore<ZNRecord> {
    private Map<String, ZNRecord> _contents = new HashMap<String, ZNRecord>();
    private Map<String, Stat> _statMap = new HashMap<String, Stat>();
    private IZkDataListener _listener = null;

    public FakePropertyStore() {
        super((ZkBaseDataAccessor)null, null, null);
    }

    public ZNRecord get(String path, Stat stat, int options) {
        return this._contents.get(path);
    }

    public Stat getStat(String path, int options) {
        return this._statMap.get(path);
    }

    public List<String> getChildNames(String parentPath, int options) {
        return this._contents.keySet().stream().filter(e -> e.startsWith(parentPath)).map(e -> e.replaceFirst(parentPath + "/", "").split("/")[0]).distinct().collect(Collectors.toList());
    }

    public boolean exists(String path, int options) {
        return this._contents.containsKey(path);
    }

    public void subscribeDataChanges(String path, IZkDataListener listener) {
        this._listener = listener;
    }

    public boolean set(String path, ZNRecord record, int expectedVersion, int options) {
        try {
            this.setContentAndStat(path, record);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean set(String path, ZNRecord record, int options) {
        try {
            this.setContentAndStat(path, record);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean remove(String path, int options) {
        List<String> descendants = this._contents.keySet().stream().filter(e -> e.startsWith(path)).collect(Collectors.toList());
        descendants.forEach(e -> this._contents.remove(e));
        return true;
    }

    public void setContentAndStat(String path, ZNRecord record) throws Exception {
        this._contents.put(path, record);
        Stat stat = new Stat();
        stat.setMtime(System.currentTimeMillis());
        this._statMap.put(path, stat);
        if (this._listener != null) {
            this._listener.handleDataChange(path, (Object)record);
        }
    }

    public void start() {
    }
}

