/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.utils.CommonConstants;

public class QueryOptionsUtils {
    private static final Map<String, String> CONFIG_RESOLVER;
    private static final RuntimeException CLASS_LOAD_ERROR;

    private QueryOptionsUtils() {
    }

    public static Map<String, String> resolveCaseInsensitiveOptions(Map<String, String> queryOptions) {
        if (CLASS_LOAD_ERROR != null) {
            throw CLASS_LOAD_ERROR;
        }
        HashMap<String, String> resolved = new HashMap<String, String>();
        for (Map.Entry<String, String> configEntry : queryOptions.entrySet()) {
            String config = CONFIG_RESOLVER.get(configEntry.getKey().toLowerCase());
            if (config != null) {
                resolved.put(config, configEntry.getValue());
                continue;
            }
            resolved.put(configEntry.getKey(), configEntry.getValue());
        }
        return resolved;
    }

    @Nullable
    public static Long getTimeoutMs(Map<String, String> queryOptions) {
        String timeoutMsString = queryOptions.get("timeoutMs");
        return QueryOptionsUtils.checkedParseLongPositive("timeoutMs", timeoutMsString);
    }

    @Nullable
    public static Long getMaxServerResponseSizeBytes(Map<String, String> queryOptions) {
        String responseSize = queryOptions.get("maxServerResponseSizeBytes");
        return QueryOptionsUtils.checkedParseLongPositive("maxServerResponseSizeBytes", responseSize);
    }

    @Nullable
    public static Long getMaxQueryResponseSizeBytes(Map<String, String> queryOptions) {
        String responseSize = queryOptions.get("maxQueryResponseSizeBytes");
        return QueryOptionsUtils.checkedParseLongPositive("maxQueryResponseSizeBytes", responseSize);
    }

    public static boolean isAndScanReorderingEnabled(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("AndScanReordering"));
    }

    public static boolean isSkipUpsert(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUpsert"));
    }

    public static boolean isSkipUpsertView(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUpsertView"));
    }

    public static long getUpsertViewFreshnessMs(Map<String, String> queryOptions) {
        String freshnessMsString = queryOptions.get("upsertViewFreshnessMs");
        return freshnessMsString != null ? Long.parseLong(freshnessMsString) : -1L;
    }

    public static boolean isScanStarTreeNodes(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("scanStarTreeNodes"));
    }

    public static boolean isSkipStarTree(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useStarTree"));
    }

    public static boolean isSkipScanFilterReorder(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useScanReorderOpt"));
    }

    @Nullable
    public static Map<String, Set<FieldConfig.IndexType>> getSkipIndexes(Map<String, String> queryOptions) {
        String skipIndexesStr = queryOptions.get("skipIndexes");
        if (skipIndexesStr == null) {
            return null;
        }
        String[] perColumnIndexSkip = StringUtils.split((String)skipIndexesStr, (char)'&');
        HashMap<String, Set<FieldConfig.IndexType>> skipIndexes = new HashMap<String, Set<FieldConfig.IndexType>>();
        for (String columnConf : perColumnIndexSkip) {
            String[] indexTypes;
            String[] conf = StringUtils.split((String)columnConf, (char)'=');
            if (conf.length != 2) {
                throw new RuntimeException("Invalid format for skipIndexes. Example of valid format: SET skipIndexes='col1=inverted,range&col2=inverted'");
            }
            String columnName = conf[0];
            for (String indexType : indexTypes = StringUtils.split((String)conf[1], (char)',')) {
                skipIndexes.computeIfAbsent(columnName, k -> new HashSet()).add(FieldConfig.IndexType.valueOf((String)indexType.toUpperCase()));
            }
        }
        return skipIndexes;
    }

    @Nullable
    public static Boolean isUseFixedReplica(Map<String, String> queryOptions) {
        String useFixedReplica = queryOptions.get("useFixedReplica");
        return useFixedReplica != null ? Boolean.valueOf(Boolean.parseBoolean(useFixedReplica)) : null;
    }

    @Nullable
    public static Integer getNumReplicaGroupsToQuery(Map<String, String> queryOptions) {
        String numReplicaGroupsToQuery = queryOptions.get("numReplicaGroupsToQuery");
        return QueryOptionsUtils.checkedParseIntPositive("numReplicaGroupsToQuery", numReplicaGroupsToQuery);
    }

    public static boolean isExplainPlanVerbose(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("explainPlanVerbose"));
    }

    public static boolean isUseMultistageEngine(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("useMultistageEngine"));
    }

    public static boolean isGetCursor(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("getCursor"));
    }

    public static Integer getCursorNumRows(Map<String, String> queryOptions) {
        String cursorNumRows = queryOptions.get("cursorNumRows");
        return QueryOptionsUtils.checkedParseIntPositive("cursorNumRows", cursorNumRows);
    }

    public static Optional<Boolean> isExplainAskingServers(Map<String, String> queryOptions) {
        String value = queryOptions.get("explainAskingServers");
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(value));
    }

    @Nullable
    public static Integer getMaxExecutionThreads(Map<String, String> queryOptions) {
        String maxExecutionThreadsString = queryOptions.get("maxExecutionThreads");
        return QueryOptionsUtils.checkedParseIntPositive("maxExecutionThreads", maxExecutionThreadsString);
    }

    @Nullable
    public static Integer getMinSegmentGroupTrimSize(Map<String, String> queryOptions) {
        String minSegmentGroupTrimSizeString = queryOptions.get("minSegmentGroupTrimSize");
        return QueryOptionsUtils.uncheckedParseInt("minSegmentGroupTrimSize", minSegmentGroupTrimSizeString);
    }

    @Nullable
    public static Integer getMinServerGroupTrimSize(Map<String, String> queryOptions) {
        String minServerGroupTrimSizeString = queryOptions.get("minServerGroupTrimSize");
        return QueryOptionsUtils.uncheckedParseInt("minServerGroupTrimSize", minServerGroupTrimSizeString);
    }

    @Nullable
    public static Integer getMinBrokerGroupTrimSize(Map<String, String> queryOptions) {
        String minBrokerGroupTrimSizeString = queryOptions.get("minBrokerGroupTrimSize");
        return QueryOptionsUtils.uncheckedParseInt("minBrokerGroupTrimSize", minBrokerGroupTrimSizeString);
    }

    @Nullable
    public static Integer getGroupTrimThreshold(Map<String, String> queryOptions) {
        String groupByTrimThreshold = queryOptions.get("groupTrimThreshold");
        return QueryOptionsUtils.uncheckedParseInt("groupTrimThreshold", groupByTrimThreshold);
    }

    public static boolean isNullHandlingEnabled(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("enableNullHandling"));
    }

    public static boolean isServerReturnFinalResult(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("serverReturnFinalResult"));
    }

    public static boolean isServerReturnFinalResultKeyUnpartitioned(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("serverReturnFinalResultKeyUnpartitioned"));
    }

    public static boolean isFilteredAggregationsSkipEmptyGroups(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("filteredAggregationsSkipEmptyGroups"));
    }

    @Nullable
    public static String getOrderByAlgorithm(Map<String, String> queryOptions) {
        return queryOptions.get("orderByAlgorithm");
    }

    @Nullable
    public static Integer getMultiStageLeafLimit(Map<String, String> queryOptions) {
        String maxLeafLimitStr = queryOptions.get("multiStageLeafLimit");
        return QueryOptionsUtils.checkedParseIntNonNegative("multiStageLeafLimit", maxLeafLimitStr);
    }

    @Nullable
    public static Integer getNumGroupsLimit(Map<String, String> queryOptions) {
        String maxNumGroupLimit = queryOptions.get("numGroupsLimit");
        return QueryOptionsUtils.checkedParseIntPositive("numGroupsLimit", maxNumGroupLimit);
    }

    @Nullable
    public static Integer getMaxInitialResultHolderCapacity(Map<String, String> queryOptions) {
        String maxInitialResultHolderCapacity = queryOptions.get("maxInitialResultHolderCapacity");
        return QueryOptionsUtils.checkedParseIntPositive("maxInitialResultHolderCapacity", maxInitialResultHolderCapacity);
    }

    public static boolean optimizeMaxInitialResultHolderCapacityEnabled(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("optimizeMaxInitialResultHolderCapacity"));
    }

    @Nullable
    public static Integer getMinInitialIndexedTableCapacity(Map<String, String> queryOptions) {
        String minInitialIndexedTableCapacity = queryOptions.get("minInitialIndexedTableCapacity");
        return QueryOptionsUtils.checkedParseIntPositive("minInitialIndexedTableCapacity", minInitialIndexedTableCapacity);
    }

    public static boolean shouldDropResults(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("dropResults"));
    }

    @Nullable
    public static Integer getMaxStreamingPendingBlocks(Map<String, String> queryOptions) {
        String maxStreamingPendingBlocks = queryOptions.get("maxStreamingPendingBlocks");
        return QueryOptionsUtils.checkedParseIntPositive("maxStreamingPendingBlocks", maxStreamingPendingBlocks);
    }

    @Nullable
    public static Integer getMaxRowsInJoin(Map<String, String> queryOptions) {
        String maxRowsInJoin = queryOptions.get("maxRowsInJoin");
        return QueryOptionsUtils.checkedParseIntPositive("maxRowsInJoin", maxRowsInJoin);
    }

    @Nullable
    public static CommonConstants.MultiStageQueryRunner.JoinOverFlowMode getJoinOverflowMode(Map<String, String> queryOptions) {
        String joinOverflowModeStr = queryOptions.get("joinOverflowMode");
        return joinOverflowModeStr != null ? CommonConstants.MultiStageQueryRunner.JoinOverFlowMode.valueOf((String)joinOverflowModeStr) : null;
    }

    @Nullable
    public static Integer getMaxRowsInWindow(Map<String, String> queryOptions) {
        String maxRowsInWindow = queryOptions.get("maxRowsInWindow");
        return QueryOptionsUtils.checkedParseIntPositive("maxRowsInWindow", maxRowsInWindow);
    }

    @Nullable
    public static CommonConstants.MultiStageQueryRunner.WindowOverFlowMode getWindowOverflowMode(Map<String, String> queryOptions) {
        String windowOverflowModeStr = queryOptions.get("windowOverflowMode");
        return windowOverflowModeStr != null ? CommonConstants.MultiStageQueryRunner.WindowOverFlowMode.valueOf((String)windowOverflowModeStr) : null;
    }

    public static boolean isSkipUnavailableServers(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUnavailableServers"));
    }

    public static boolean isSecondaryWorkload(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("isSecondaryWorkload"));
    }

    @Nullable
    private static Integer uncheckedParseInt(String optionName, @Nullable String optionValue) {
        if (optionValue == null) {
            return null;
        }
        try {
            return Integer.parseInt(optionValue);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.format("%s must be an integer, got: %s", optionName, optionValue));
        }
    }

    @Nullable
    private static Integer checkedParseIntPositive(String optionName, @Nullable String optionValue) {
        return QueryOptionsUtils.checkedParseInt(optionName, optionValue, 1);
    }

    @Nullable
    private static Integer checkedParseIntNonNegative(String optionName, @Nullable String optionValue) {
        return QueryOptionsUtils.checkedParseInt(optionName, optionValue, 0);
    }

    @Nullable
    private static Integer checkedParseInt(String optionName, @Nullable String optionValue, int minValue) {
        int value;
        if (optionValue == null) {
            return null;
        }
        try {
            value = Integer.parseInt(optionValue);
        }
        catch (NumberFormatException nfe) {
            throw QueryOptionsUtils.intParseException(optionName, optionValue, minValue);
        }
        if (value < minValue) {
            throw QueryOptionsUtils.intParseException(optionName, optionValue, minValue);
        }
        return value;
    }

    private static IllegalArgumentException intParseException(String optionName, String optionValue, int minValue) {
        return new IllegalArgumentException(String.format("%s must be a number between %d and 2^31-1, got: %s", optionName, minValue, optionValue));
    }

    @Nullable
    private static Long checkedParseLongPositive(String optionName, @Nullable String optionValue) {
        return QueryOptionsUtils.checkedParseLong(optionName, optionValue, 1L);
    }

    @Nullable
    private static Long checkedParseLong(String optionName, @Nullable String optionValue, long minValue) {
        long value;
        if (optionValue == null) {
            return null;
        }
        try {
            value = Long.parseLong(optionValue);
        }
        catch (NumberFormatException nfe) {
            throw QueryOptionsUtils.longParseException(optionName, optionValue, minValue);
        }
        if (value < minValue) {
            throw QueryOptionsUtils.longParseException(optionName, optionValue, minValue);
        }
        return value;
    }

    private static IllegalArgumentException longParseException(String optionName, @Nullable String optionValue, long minValue) {
        return new IllegalArgumentException(String.format("%s must be a number between %d and 2^63-1, got: %s", optionName, minValue, optionValue));
    }

    static {
        HashMap<String, String> configResolver = new HashMap<String, String>();
        IllegalAccessException classLoadError = null;
        try {
            for (Field declaredField : CommonConstants.Broker.Request.QueryOptionKey.class.getDeclaredFields()) {
                int mods;
                if (!declaredField.getType().equals(String.class) || !Modifier.isStatic(mods = declaredField.getModifiers()) || !Modifier.isFinal(mods)) continue;
                String config = (String)declaredField.get(null);
                configResolver.put(config.toLowerCase(), config);
            }
        }
        catch (IllegalAccessException e) {
            configResolver = null;
            classLoadError = e;
        }
        CONFIG_RESOLVER = configResolver == null ? null : ImmutableMap.copyOf(configResolver);
        CLASS_LOAD_ERROR = classLoadError == null ? null : new RuntimeException("Failure to build case insensitive mapping.", classLoadError);
    }
}

