/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hc.core5.net.URIBuilder;

public class RoundRobinURIProvider {
    private final List<URI> _uris;
    private int _index;

    public RoundRobinURIProvider(List<URI> originalUris, boolean resolveHost) throws UnknownHostException, URISyntaxException {
        this._uris = resolveHost ? this.resolveHostsToIPAddresses(originalUris) : List.copyOf(originalUris);
        this._index = ThreadLocalRandom.current().nextInt(this._uris.size());
    }

    public int numAddresses() {
        return this._uris.size();
    }

    public URI next() {
        URI result = this._uris.get(this._index);
        this._index = (this._index + 1) % this._uris.size();
        return result;
    }

    private List<URI> resolveHostToIPAddresses(URI originalUri) throws UnknownHostException, URISyntaxException {
        ArrayList<URI> resolvedUris = new ArrayList<URI>();
        String hostName = originalUri.getHost();
        if (InetAddresses.isInetAddress((String)hostName)) {
            resolvedUris.add(originalUri);
        } else {
            InetAddress[] addresses = InetAddress.getAllByName(hostName);
            URIBuilder uriBuilder = new URIBuilder(originalUri);
            for (InetAddress address : addresses) {
                String ip = address.getHostAddress();
                resolvedUris.add(uriBuilder.setHost(ip).build());
            }
        }
        return resolvedUris;
    }

    private List<URI> resolveHostsToIPAddresses(List<URI> originalUri) throws UnknownHostException, URISyntaxException {
        ArrayList<URI> resolvedUris = new ArrayList<URI>();
        for (URI uri : originalUri) {
            resolvedUris.addAll(this.resolveHostToIPAddresses(uri));
        }
        return resolvedUris;
    }
}

