/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static String consolidateExceptionMessages(Throwable e) {
        StringBuilder sb = new StringBuilder();
        int maxCauses = 10;
        while (e != null && maxCauses-- > 0) {
            sb.append(ExceptionUtils.getStackTrace(e, 3));
            e = e.getCause();
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable e) {
        return ExceptionUtils.getStackTrace(e, Integer.MAX_VALUE);
    }

    public static String getStackTrace(Throwable e, int maxLines) {
        return ExceptionUtils.getStackTrace(e, maxLines, Integer.MAX_VALUE);
    }

    public static String getStackTrace(Throwable e, int maxLines, int maxLineLength) {
        StringBuilder sb = new StringBuilder();
        while (e != null) {
            sb.append(e.getMessage()).append("\n");
            for (StackTraceElement ste : e.getStackTrace()) {
                sb.append(ste.toString()).append("\n");
                if (maxLines-- <= 0) {
                    return sb.toString();
                }
                if (sb.length() <= maxLineLength) continue;
                return sb.toString();
            }
            e = e.getCause();
        }
        return sb.toString();
    }
}

