/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.pinot.common.utils.ArrayListUtils;
import org.apache.pinot.segment.spi.memory.PinotInputStream;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.EqualityUtils;

@JsonPropertyOrder(value={"columnNames", "columnDataTypes"})
public class DataSchema {
    private final String[] _columnNames;
    private final ColumnDataType[] _columnDataTypes;
    private ColumnDataType[] _storedColumnDataTypes;
    public static final DataSchema EXPLAIN_RESULT_SCHEMA = new DataSchema(new String[]{"Operator", "Operator_Id", "Parent_Id"}, new ColumnDataType[]{ColumnDataType.STRING, ColumnDataType.INT, ColumnDataType.INT});

    @JsonCreator
    public DataSchema(@JsonProperty(value="columnNames") String[] columnNames, @JsonProperty(value="columnDataTypes") ColumnDataType[] columnDataTypes) {
        this._columnNames = columnNames;
        this._columnDataTypes = columnDataTypes;
    }

    public int size() {
        return this._columnNames.length;
    }

    public String getColumnName(int index) {
        return this._columnNames[index];
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public ColumnDataType getColumnDataType(int index) {
        return this._columnDataTypes[index];
    }

    public ColumnDataType[] getColumnDataTypes() {
        return this._columnDataTypes;
    }

    @JsonIgnore
    public ColumnDataType[] getStoredColumnDataTypes() {
        ColumnDataType[] storedColumnDataTypes = this._storedColumnDataTypes;
        if (storedColumnDataTypes == null) {
            int numColumns = this._columnDataTypes.length;
            storedColumnDataTypes = new ColumnDataType[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                storedColumnDataTypes[i] = this._columnDataTypes[i].getStoredType();
            }
            this._storedColumnDataTypes = storedColumnDataTypes;
        }
        return storedColumnDataTypes;
    }

    public byte[] toBytes() throws IOException {
        byte[] bytes;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int length = this._columnNames.length;
        dataOutputStream.writeInt(length);
        for (String string : this._columnNames) {
            bytes = string.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        for (ColumnDataType columnDataType : this._columnDataTypes) {
            bytes = columnDataType.name().getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static DataSchema fromBytes(ByteBuffer buffer) throws IOException {
        byte[] bytes;
        int length;
        int i;
        int numColumns = buffer.getInt();
        String[] columnNames = new String[numColumns];
        ColumnDataType[] columnDataTypes = new ColumnDataType[numColumns];
        for (i = 0; i < numColumns; ++i) {
            length = buffer.getInt();
            bytes = new byte[length];
            buffer.get(bytes);
            columnNames[i] = new String(bytes, StandardCharsets.UTF_8);
        }
        for (i = 0; i < numColumns; ++i) {
            length = buffer.getInt();
            bytes = new byte[length];
            buffer.get(bytes);
            columnDataTypes[i] = ColumnDataType.valueOf(new String(bytes, StandardCharsets.UTF_8));
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    public static DataSchema fromBytes(PinotInputStream buffer) throws IOException {
        byte[] bytes;
        int length;
        int i;
        int numColumns = buffer.readInt();
        String[] columnNames = new String[numColumns];
        ColumnDataType[] columnDataTypes = new ColumnDataType[numColumns];
        for (i = 0; i < numColumns; ++i) {
            length = buffer.readInt();
            bytes = new byte[length];
            buffer.readFully(bytes);
            columnNames[i] = new String(bytes, StandardCharsets.UTF_8);
        }
        for (i = 0; i < numColumns; ++i) {
            length = buffer.readInt();
            bytes = new byte[length];
            buffer.readFully(bytes);
            columnDataTypes[i] = ColumnDataType.valueOf(new String(bytes, StandardCharsets.UTF_8));
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    public DataSchema clone() {
        return new DataSchema((String[])this._columnNames.clone(), (ColumnDataType[])this._columnDataTypes.clone());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int numColumns = this._columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            stringBuilder.append(this._columnNames[i]).append('(').append((Object)this._columnDataTypes[i]).append(')').append(',');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        return stringBuilder.toString();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof DataSchema) {
            DataSchema anotherDataSchema = (DataSchema)anObject;
            return Arrays.equals(this._columnNames, anotherDataSchema._columnNames) && Arrays.equals((Object[])this._columnDataTypes, (Object[])anotherDataSchema._columnDataTypes);
        }
        return false;
    }

    public int hashCode() {
        return EqualityUtils.hashCodeOf((int)Arrays.hashCode(this._columnNames), (int)Arrays.hashCode((Object[])this._columnDataTypes));
    }

    public RelDataType toRelDataType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> columnTypes = new ArrayList<RelDataType>(this._columnDataTypes.length);
        for (ColumnDataType columnDataType : this._columnDataTypes) {
            columnTypes.add(columnDataType.toType(typeFactory));
        }
        return typeFactory.createStructType(columnTypes, Arrays.asList(this._columnNames));
    }

    public static abstract class ColumnDataType
    extends Enum<ColumnDataType> {
        public static final /* enum */ ColumnDataType INT = new ColumnDataType(0){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
        };
        public static final /* enum */ ColumnDataType LONG = new ColumnDataType(0L){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
        };
        public static final /* enum */ ColumnDataType FLOAT = new ColumnDataType(Float.valueOf(0.0f)){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.REAL);
            }
        };
        public static final /* enum */ ColumnDataType DOUBLE = new ColumnDataType(0.0){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
        };
        public static final /* enum */ ColumnDataType BIG_DECIMAL = new ColumnDataType(CommonConstants.NullValuePlaceHolder.BIG_DECIMAL){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.DECIMAL);
            }
        };
        public static final /* enum */ ColumnDataType BOOLEAN = new ColumnDataType(INT, 0){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
        };
        public static final /* enum */ ColumnDataType TIMESTAMP = new ColumnDataType(LONG, 0L){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
        };
        public static final /* enum */ ColumnDataType STRING = new ColumnDataType(""){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
        };
        public static final /* enum */ ColumnDataType JSON = new ColumnDataType(STRING, ""){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
        };
        public static final /* enum */ ColumnDataType MAP = new ColumnDataType(CommonConstants.NullValuePlaceHolder.MAP){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.MAP);
            }
        };
        public static final /* enum */ ColumnDataType BYTES = new ColumnDataType(CommonConstants.NullValuePlaceHolder.INTERNAL_BYTES){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.VARBINARY);
            }
        };
        public static final /* enum */ ColumnDataType OBJECT = new ColumnDataType(null){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.ANY);
            }
        };
        public static final /* enum */ ColumnDataType INT_ARRAY = new ColumnDataType(CommonConstants.NullValuePlaceHolder.INT_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(INT.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType LONG_ARRAY = new ColumnDataType(CommonConstants.NullValuePlaceHolder.LONG_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(LONG.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType FLOAT_ARRAY = new ColumnDataType(CommonConstants.NullValuePlaceHolder.FLOAT_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(FLOAT.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType DOUBLE_ARRAY = new ColumnDataType(CommonConstants.NullValuePlaceHolder.DOUBLE_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(DOUBLE.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType BOOLEAN_ARRAY = new ColumnDataType(INT_ARRAY, CommonConstants.NullValuePlaceHolder.INT_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(BOOLEAN.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType TIMESTAMP_ARRAY = new ColumnDataType(LONG_ARRAY, CommonConstants.NullValuePlaceHolder.LONG_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(TIMESTAMP.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType STRING_ARRAY = new ColumnDataType(CommonConstants.NullValuePlaceHolder.STRING_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(STRING.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType BYTES_ARRAY = new ColumnDataType(CommonConstants.NullValuePlaceHolder.BYTES_ARRAY){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createArrayType(BYTES.toType(typeFactory), -1L);
            }
        };
        public static final /* enum */ ColumnDataType UNKNOWN = new ColumnDataType(null){

            @Override
            public RelDataType toType(RelDataTypeFactory typeFactory) {
                return typeFactory.createSqlType(SqlTypeName.ANY);
            }
        };
        private static final EnumSet<ColumnDataType> NUMERIC_TYPES;
        private static final EnumSet<ColumnDataType> INTEGRAL_TYPES;
        private static final EnumSet<ColumnDataType> ARRAY_TYPES;
        private static final EnumSet<ColumnDataType> NUMERIC_ARRAY_TYPES;
        private static final EnumSet<ColumnDataType> INTEGRAL_ARRAY_TYPES;
        private final ColumnDataType _storedColumnDataType;
        private final Object _nullPlaceholder;
        private static final /* synthetic */ ColumnDataType[] $VALUES;

        public static ColumnDataType[] values() {
            return (ColumnDataType[])$VALUES.clone();
        }

        public static ColumnDataType valueOf(String name) {
            return Enum.valueOf(ColumnDataType.class, name);
        }

        private ColumnDataType(Object nullPlaceHolder) {
            this._storedColumnDataType = this;
            this._nullPlaceholder = nullPlaceHolder;
        }

        private ColumnDataType(ColumnDataType storedColumnDataType, Object nullPlaceHolder) {
            this._storedColumnDataType = storedColumnDataType;
            this._nullPlaceholder = nullPlaceHolder;
        }

        public Object getNullPlaceholder() {
            return this._nullPlaceholder;
        }

        public ColumnDataType getStoredType() {
            return this._storedColumnDataType;
        }

        public boolean isNumber() {
            return NUMERIC_TYPES.contains((Object)this);
        }

        public boolean isWholeNumber() {
            return INTEGRAL_TYPES.contains((Object)this);
        }

        public boolean isArray() {
            return ARRAY_TYPES.contains((Object)this);
        }

        public boolean isNumberArray() {
            return NUMERIC_ARRAY_TYPES.contains((Object)this);
        }

        public boolean isWholeNumberArray() {
            return INTEGRAL_ARRAY_TYPES.contains((Object)this);
        }

        public boolean isCompatible(ColumnDataType anotherColumnDataType) {
            return this == anotherColumnDataType || this.isNumber() && anotherColumnDataType.isNumber() || this.isNumberArray() && anotherColumnDataType.isNumberArray();
        }

        public FieldSpec.DataType toDataType() {
            switch (this) {
                case INT: 
                case INT_ARRAY: {
                    return FieldSpec.DataType.INT;
                }
                case LONG: 
                case LONG_ARRAY: {
                    return FieldSpec.DataType.LONG;
                }
                case FLOAT: 
                case FLOAT_ARRAY: {
                    return FieldSpec.DataType.FLOAT;
                }
                case DOUBLE: 
                case DOUBLE_ARRAY: {
                    return FieldSpec.DataType.DOUBLE;
                }
                case BIG_DECIMAL: {
                    return FieldSpec.DataType.BIG_DECIMAL;
                }
                case BOOLEAN: 
                case BOOLEAN_ARRAY: {
                    return FieldSpec.DataType.BOOLEAN;
                }
                case TIMESTAMP: 
                case TIMESTAMP_ARRAY: {
                    return FieldSpec.DataType.TIMESTAMP;
                }
                case STRING: 
                case STRING_ARRAY: {
                    return FieldSpec.DataType.STRING;
                }
                case JSON: {
                    return FieldSpec.DataType.JSON;
                }
                case BYTES: 
                case BYTES_ARRAY: {
                    return FieldSpec.DataType.BYTES;
                }
                case UNKNOWN: {
                    return FieldSpec.DataType.UNKNOWN;
                }
            }
            throw new IllegalStateException(String.format("Cannot convert ColumnDataType: %s to DataType", new Object[]{this}));
        }

        public Object toInternal(Object value) {
            switch (this) {
                case BOOLEAN: {
                    return (Boolean)value != false ? 1 : 0;
                }
                case TIMESTAMP: {
                    return ((Timestamp)value).getTime();
                }
                case BYTES: {
                    return new ByteArray((byte[])value);
                }
                case BOOLEAN_ARRAY: {
                    return ColumnDataType.fromBooleanArray((boolean[])value);
                }
                case TIMESTAMP_ARRAY: {
                    return ColumnDataType.fromTimestampArray((Timestamp[])value);
                }
                case OBJECT: {
                    if (value instanceof Boolean) {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    if (value instanceof Timestamp) {
                        return ((Timestamp)value).getTime();
                    }
                    if (value instanceof byte[]) {
                        return new ByteArray((byte[])value);
                    }
                    if (value instanceof boolean[]) {
                        return ColumnDataType.fromBooleanArray((boolean[])value);
                    }
                    if (value instanceof Timestamp[]) {
                        return ColumnDataType.fromTimestampArray((Timestamp[])value);
                    }
                    return value;
                }
            }
            return value;
        }

        public Object toExternal(Object value) {
            switch (this) {
                case BOOLEAN: {
                    return (Integer)value == 1;
                }
                case TIMESTAMP: {
                    return new Timestamp((Long)value);
                }
                case BYTES: {
                    return ((ByteArray)value).getBytes();
                }
                case BOOLEAN_ARRAY: {
                    return ColumnDataType.toBooleanArray((int[])value);
                }
                case TIMESTAMP_ARRAY: {
                    return ColumnDataType.toTimestampArray((long[])value);
                }
            }
            return value;
        }

        public Serializable convert(Object value) {
            switch (this) {
                case INT: {
                    return Integer.valueOf(((Number)value).intValue());
                }
                case LONG: {
                    return Long.valueOf(((Number)value).longValue());
                }
                case FLOAT: {
                    return Float.valueOf(((Number)value).floatValue());
                }
                case DOUBLE: {
                    return Double.valueOf(((Number)value).doubleValue());
                }
                case BIG_DECIMAL: {
                    return (BigDecimal)value;
                }
                case BOOLEAN: {
                    return Boolean.valueOf((Integer)value == 1);
                }
                case TIMESTAMP: {
                    return new Timestamp((Long)value);
                }
                case STRING: 
                case JSON: {
                    return value.toString();
                }
                case BYTES: {
                    return ((ByteArray)value).getBytes();
                }
                case INT_ARRAY: {
                    return ColumnDataType.toIntArray(value);
                }
                case LONG_ARRAY: {
                    return ColumnDataType.toLongArray(value);
                }
                case FLOAT_ARRAY: {
                    return ColumnDataType.toFloatArray(value);
                }
                case DOUBLE_ARRAY: {
                    return ColumnDataType.toDoubleArray(value);
                }
                case STRING_ARRAY: {
                    return ColumnDataType.toStringArray(value);
                }
                case BOOLEAN_ARRAY: {
                    return ColumnDataType.toBooleanArray(ColumnDataType.toIntArray(value));
                }
                case TIMESTAMP_ARRAY: {
                    return ColumnDataType.toTimestampArray(ColumnDataType.toLongArray(value));
                }
                case BYTES_ARRAY: {
                    return (byte[][])value;
                }
                case UNKNOWN: 
                case OBJECT: {
                    return (Serializable)value;
                }
            }
            throw new IllegalStateException(String.format("Cannot convert: '%s' to type: %s", new Object[]{value, this}));
        }

        public Serializable format(Object value) {
            switch (this) {
                case BIG_DECIMAL: {
                    return ((BigDecimal)value).toPlainString();
                }
                case TIMESTAMP: {
                    assert (value instanceof Timestamp);
                    return value.toString();
                }
                case BYTES: {
                    return BytesUtils.toHexString((byte[])((byte[])value));
                }
                case TIMESTAMP_ARRAY: {
                    return ColumnDataType.formatTimestampArray((Timestamp[])value);
                }
            }
            return (Serializable)value;
        }

        public Serializable convertAndFormat(Object value) {
            switch (this) {
                case INT: {
                    return Integer.valueOf(((Number)value).intValue());
                }
                case LONG: {
                    return Long.valueOf(((Number)value).longValue());
                }
                case FLOAT: {
                    return Float.valueOf(((Number)value).floatValue());
                }
                case DOUBLE: {
                    return Double.valueOf(((Number)value).doubleValue());
                }
                case BIG_DECIMAL: {
                    return ((BigDecimal)value).toPlainString();
                }
                case BOOLEAN: {
                    return Boolean.valueOf((Integer)value == 1);
                }
                case TIMESTAMP: {
                    return new Timestamp((Long)value).toString();
                }
                case STRING: 
                case JSON: {
                    return value.toString();
                }
                case BYTES: {
                    return ((ByteArray)value).toHexString();
                }
                case MAP: {
                    return this.toMap(value);
                }
                case INT_ARRAY: {
                    return (int[])value;
                }
                case LONG_ARRAY: {
                    return ColumnDataType.toLongArray(value);
                }
                case FLOAT_ARRAY: {
                    return (float[])value;
                }
                case DOUBLE_ARRAY: {
                    return ColumnDataType.toDoubleArray(value);
                }
                case STRING_ARRAY: {
                    return (String[])value;
                }
                case BOOLEAN_ARRAY: {
                    return ColumnDataType.toBooleanArray((int[])value);
                }
                case TIMESTAMP_ARRAY: {
                    return ColumnDataType.formatTimestampArray((long[])value);
                }
                case BYTES_ARRAY: {
                    return (byte[][])value;
                }
            }
            throw new IllegalStateException(String.format("Cannot convert and format: '%s' to type: %s", new Object[]{value, this}));
        }

        private Serializable toMap(Object value) {
            if (value instanceof Serializable) {
                return (Serializable)value;
            }
            if (value instanceof Map) {
                return new HashMap((Map)value);
            }
            throw new IllegalStateException(String.format("Cannot convert: '%s' to Map", value));
        }

        private static int[] toIntArray(Object value) {
            if (value instanceof int[]) {
                return (int[])value;
            }
            if (value instanceof IntArrayList) {
                return ArrayListUtils.toIntArray((IntArrayList)value);
            }
            throw new IllegalStateException(String.format("Cannot convert: '%s' to int[]", value));
        }

        private static float[] toFloatArray(Object value) {
            if (value instanceof float[]) {
                return (float[])value;
            }
            if (value instanceof FloatArrayList) {
                return ArrayListUtils.toFloatArray((FloatArrayList)value);
            }
            throw new IllegalStateException(String.format("Cannot convert: '%s' to float[]", value));
        }

        private static double[] toDoubleArray(Object value) {
            if (value instanceof double[]) {
                return (double[])value;
            }
            if (value instanceof DoubleArrayList) {
                return ArrayListUtils.toDoubleArray((DoubleArrayList)value);
            }
            if (value instanceof int[]) {
                int[] intValues = (int[])value;
                int length = intValues.length;
                double[] doubleValues = new double[length];
                for (int i = 0; i < length; ++i) {
                    doubleValues[i] = intValues[i];
                }
                return doubleValues;
            }
            if (value instanceof long[]) {
                long[] longValues = (long[])value;
                int length = longValues.length;
                double[] doubleValues = new double[length];
                for (int i = 0; i < length; ++i) {
                    doubleValues[i] = longValues[i];
                }
                return doubleValues;
            }
            float[] floatValues = (float[])value;
            int length = floatValues.length;
            double[] doubleValues = new double[length];
            for (int i = 0; i < length; ++i) {
                doubleValues[i] = floatValues[i];
            }
            return doubleValues;
        }

        private static long[] toLongArray(Object value) {
            if (value instanceof long[]) {
                return (long[])value;
            }
            if (value instanceof LongArrayList) {
                return ArrayListUtils.toLongArray((LongArrayList)value);
            }
            int[] intValues = (int[])value;
            int length = intValues.length;
            long[] longValues = new long[length];
            for (int i = 0; i < length; ++i) {
                longValues[i] = intValues[i];
            }
            return longValues;
        }

        private static String[] toStringArray(Object value) {
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof ObjectArrayList) {
                return ArrayListUtils.toStringArray((ObjectArrayList<String>)((ObjectArrayList)value));
            }
            throw new IllegalStateException(String.format("Cannot convert: '%s' to String[]", value));
        }

        private static boolean[] toBooleanArray(int[] intArray) {
            int length = intArray.length;
            boolean[] booleanArray = new boolean[length];
            for (int i = 0; i < length; ++i) {
                booleanArray[i] = intArray[i] == 1;
            }
            return booleanArray;
        }

        private static int[] fromBooleanArray(boolean[] booleanArray) {
            int length = booleanArray.length;
            int[] intArray = new int[length];
            for (int i = 0; i < length; ++i) {
                intArray[i] = booleanArray[i] ? 1 : 0;
            }
            return intArray;
        }

        private static Timestamp[] toTimestampArray(long[] longArray) {
            int length = longArray.length;
            Timestamp[] timestampArray = new Timestamp[length];
            for (int i = 0; i < length; ++i) {
                timestampArray[i] = new Timestamp(longArray[i]);
            }
            return timestampArray;
        }

        private static long[] fromTimestampArray(Timestamp[] timestampArray) {
            int length = timestampArray.length;
            long[] longArray = new long[length];
            for (int i = 0; i < length; ++i) {
                longArray[i] = timestampArray[i].getTime();
            }
            return longArray;
        }

        private static String[] formatTimestampArray(long[] longArray) {
            int length = longArray.length;
            String[] formattedTimestampArray = new String[length];
            for (int i = 0; i < length; ++i) {
                formattedTimestampArray[i] = new Timestamp(longArray[i]).toString();
            }
            return formattedTimestampArray;
        }

        private static String[] formatTimestampArray(Timestamp[] timestampArray) {
            int length = timestampArray.length;
            String[] formattedTimestampArray = new String[length];
            for (int i = 0; i < length; ++i) {
                formattedTimestampArray[i] = timestampArray[i].toString();
            }
            return formattedTimestampArray;
        }

        public static ColumnDataType fromDataType(FieldSpec.DataType dataType, boolean isSingleValue) {
            return isSingleValue ? ColumnDataType.fromDataTypeSV(dataType) : ColumnDataType.fromDataTypeMV(dataType);
        }

        public static ColumnDataType fromDataTypeSV(FieldSpec.DataType dataType) {
            switch (dataType) {
                case INT: {
                    return INT;
                }
                case LONG: {
                    return LONG;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case BIG_DECIMAL: {
                    return BIG_DECIMAL;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case TIMESTAMP: {
                    return TIMESTAMP;
                }
                case STRING: {
                    return STRING;
                }
                case JSON: {
                    return JSON;
                }
                case BYTES: {
                    return BYTES;
                }
                case MAP: {
                    return MAP;
                }
                case UNKNOWN: {
                    return UNKNOWN;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + dataType);
        }

        public static ColumnDataType fromDataTypeMV(FieldSpec.DataType dataType) {
            switch (dataType) {
                case INT: {
                    return INT_ARRAY;
                }
                case LONG: {
                    return LONG_ARRAY;
                }
                case FLOAT: {
                    return FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return DOUBLE_ARRAY;
                }
                case BOOLEAN: {
                    return BOOLEAN_ARRAY;
                }
                case TIMESTAMP: {
                    return TIMESTAMP_ARRAY;
                }
                case STRING: {
                    return STRING_ARRAY;
                }
                case BYTES: {
                    return BYTES_ARRAY;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + dataType);
        }

        public abstract RelDataType toType(RelDataTypeFactory var1);

        static {
            $VALUES = new ColumnDataType[]{INT, LONG, FLOAT, DOUBLE, BIG_DECIMAL, BOOLEAN, TIMESTAMP, STRING, JSON, MAP, BYTES, OBJECT, INT_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, BOOLEAN_ARRAY, TIMESTAMP_ARRAY, STRING_ARRAY, BYTES_ARRAY, UNKNOWN};
            NUMERIC_TYPES = EnumSet.of(INT, LONG, FLOAT, DOUBLE, BIG_DECIMAL);
            INTEGRAL_TYPES = EnumSet.of(INT, LONG);
            ARRAY_TYPES = EnumSet.of(INT_ARRAY, new ColumnDataType[]{LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, STRING_ARRAY, BOOLEAN_ARRAY, TIMESTAMP_ARRAY, BYTES_ARRAY});
            NUMERIC_ARRAY_TYPES = EnumSet.of(INT_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY);
            INTEGRAL_ARRAY_TYPES = EnumSet.of(INT_ARRAY, LONG_ARRAY);
        }
    }
}

