/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.cache.Cache;
import org.mindrot.jbcrypt.BCrypt;

public class BcryptUtils {
    private static final int DEFAULT_LOG_ROUNDS = 10;
    private static String _bcryptPassword = null;

    private BcryptUtils() {
    }

    public static String encrypt(String password) {
        return BcryptUtils.encrypt(password, 10);
    }

    public static String encrypt(String password, int saltLogRounds) {
        _bcryptPassword = BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)saltLogRounds));
        return _bcryptPassword;
    }

    public static boolean checkpw(String password, String encryptedPassword) {
        try {
            return BCrypt.checkpw((String)password, (String)encryptedPassword);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkpwWithCache(String password, String encryptedPassword, Cache<String, String> userPasswordAuthCache) {
        boolean isMatch = true;
        String cachedPassword = (String)userPasswordAuthCache.getIfPresent((Object)encryptedPassword);
        if ((cachedPassword == null || !cachedPassword.equals(password)) && (isMatch = BcryptUtils.checkpw(password, encryptedPassword))) {
            userPasswordAuthCache.put((Object)encryptedPassword, (Object)password);
        }
        return isMatch;
    }
}

