/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response.broker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.pinot.common.datatable.StatMap;
import org.apache.pinot.common.response.BrokerResponse;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;

@JsonPropertyOrder(value={"resultTable", "numRowsResultSet", "partialResult", "exceptions", "numGroupsLimitReached", "maxRowsInJoinReached", "maxRowsInWindowReached", "timeUsedMs", "stageStats", "maxRowsInOperator", "requestId", "brokerId", "numDocsScanned", "totalDocs", "numEntriesScannedInFilter", "numEntriesScannedPostFilter", "numServersQueried", "numServersResponded", "numSegmentsQueried", "numSegmentsProcessed", "numSegmentsMatched", "numConsumingSegmentsQueried", "numConsumingSegmentsProcessed", "numConsumingSegmentsMatched", "minConsumingFreshnessTimeMs", "numSegmentsPrunedByBroker", "numSegmentsPrunedByServer", "numSegmentsPrunedInvalid", "numSegmentsPrunedByLimit", "numSegmentsPrunedByValue", "brokerReduceTimeMs", "offlineThreadCpuTimeNs", "realtimeThreadCpuTimeNs", "offlineSystemActivitiesCpuTimeNs", "realtimeSystemActivitiesCpuTimeNs", "offlineResponseSerializationCpuTimeNs", "realtimeResponseSerializationCpuTimeNs", "offlineTotalCpuTimeNs", "realtimeTotalCpuTimeNs", "explainPlanNumEmptyFilterSegments", "explainPlanNumMatchAllFilterSegments", "traceInfo", "tablesQueried"})
public class BrokerResponseNativeV2
implements BrokerResponse {
    private final StatMap<StatKey> _brokerStats = new StatMap<StatKey>(StatKey.class);
    private final List<QueryProcessingException> _exceptions = new ArrayList<QueryProcessingException>();
    private ResultTable _resultTable;
    private int _numRowsResultSet;
    private boolean _maxRowsInJoinReached;
    private boolean _maxRowsInWindowReached;
    private long _timeUsedMs;
    private ObjectNode _stageStats;
    private long _maxRowsInOperator;
    private String _requestId;
    private String _brokerId;
    private int _numServersQueried;
    private int _numServersResponded;
    private long _brokerReduceTimeMs;
    private Set<String> _tablesQueried = Set.of();

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ResultTable getResultTable() {
        return this._resultTable;
    }

    @Override
    public void setResultTable(@Nullable ResultTable resultTable) {
        this._resultTable = resultTable;
        if (resultTable != null) {
            this._numRowsResultSet = resultTable.getRows().size();
        }
    }

    @Override
    public int getNumRowsResultSet() {
        return this._numRowsResultSet;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public boolean isPartialResult() {
        return this.getExceptionsSize() > 0 || this.isNumGroupsLimitReached() || this.isMaxRowsInJoinReached();
    }

    @Override
    public List<QueryProcessingException> getExceptions() {
        return this._exceptions;
    }

    public void addException(QueryProcessingException exception) {
        this._exceptions.add(exception);
    }

    public void addException(ProcessingException exception) {
        this.addException(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
    }

    @Override
    public boolean isNumGroupsLimitReached() {
        return this._brokerStats.getBoolean(StatKey.NUM_GROUPS_LIMIT_REACHED);
    }

    public void mergeNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._brokerStats.merge(StatKey.NUM_GROUPS_LIMIT_REACHED, numGroupsLimitReached);
    }

    @Override
    public boolean isMaxRowsInJoinReached() {
        return this._maxRowsInJoinReached;
    }

    public void mergeMaxRowsInJoinReached(boolean maxRowsInJoinReached) {
        this._maxRowsInJoinReached |= maxRowsInJoinReached;
    }

    @Override
    public boolean isMaxRowsInWindowReached() {
        return this._maxRowsInWindowReached;
    }

    public void mergeMaxRowsInWindowReached(boolean maxRowsInWindowReached) {
        this._maxRowsInWindowReached |= maxRowsInWindowReached;
    }

    public ObjectNode getStageStats() {
        return this._stageStats;
    }

    public void setStageStats(ObjectNode stageStats) {
        this._stageStats = stageStats;
    }

    public long getMaxRowsInOperator() {
        return this._maxRowsInOperator;
    }

    public void mergeMaxRowsInOperator(long maxRows) {
        this._maxRowsInOperator = Math.max(this._maxRowsInOperator, maxRows);
    }

    @Override
    public long getTimeUsedMs() {
        return this._timeUsedMs;
    }

    public void setTimeUsedMs(long timeUsedMs) {
        this._timeUsedMs = timeUsedMs;
    }

    @Override
    public String getRequestId() {
        return this._requestId;
    }

    @Override
    public void setRequestId(String requestId) {
        this._requestId = requestId;
    }

    @Override
    public String getBrokerId() {
        return this._brokerId;
    }

    @Override
    public void setBrokerId(String brokerId) {
        this._brokerId = brokerId;
    }

    @Override
    public long getNumDocsScanned() {
        return this._brokerStats.getLong(StatKey.NUM_DOCS_SCANNED);
    }

    @Override
    public long getTotalDocs() {
        return this._brokerStats.getLong(StatKey.TOTAL_DOCS);
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        return this._brokerStats.getLong(StatKey.NUM_ENTRIES_SCANNED_IN_FILTER);
    }

    @Override
    public long getNumEntriesScannedPostFilter() {
        return this._brokerStats.getLong(StatKey.NUM_ENTRIES_SCANNED_POST_FILTER);
    }

    @Override
    public int getNumServersQueried() {
        return this._numServersQueried;
    }

    public void setNumServersQueried(int numServersQueried) {
        this._numServersQueried = numServersQueried;
    }

    @Override
    public int getNumServersResponded() {
        return this._numServersResponded;
    }

    public void setNumServersResponded(int numServersResponded) {
        this._numServersResponded = numServersResponded;
    }

    @Override
    public long getNumSegmentsQueried() {
        return this._brokerStats.getLong(StatKey.NUM_SEGMENTS_QUERIED);
    }

    @Override
    public long getNumSegmentsProcessed() {
        return this._brokerStats.getLong(StatKey.NUM_SEGMENTS_PROCESSED);
    }

    @Override
    public long getNumSegmentsMatched() {
        return this._brokerStats.getLong(StatKey.NUM_SEGMENTS_MATCHED);
    }

    @Override
    public long getNumConsumingSegmentsQueried() {
        return this._brokerStats.getLong(StatKey.NUM_CONSUMING_SEGMENTS_QUERIED);
    }

    @Override
    public long getNumConsumingSegmentsProcessed() {
        return this._brokerStats.getLong(StatKey.NUM_CONSUMING_SEGMENTS_PROCESSED);
    }

    @Override
    public long getNumConsumingSegmentsMatched() {
        return this._brokerStats.getLong(StatKey.NUM_CONSUMING_SEGMENTS_MATCHED);
    }

    @Override
    public long getMinConsumingFreshnessTimeMs() {
        return this._brokerStats.getLong(StatKey.MIN_CONSUMING_FRESHNESS_TIME_MS);
    }

    @Override
    public long getNumSegmentsPrunedByBroker() {
        return 0L;
    }

    @Override
    public long getNumSegmentsPrunedByServer() {
        return this._brokerStats.getLong(StatKey.NUM_SEGMENTS_PRUNED_BY_SERVER);
    }

    @Override
    public long getNumSegmentsPrunedInvalid() {
        return this._brokerStats.getLong(StatKey.NUM_SEGMENTS_PRUNED_INVALID);
    }

    @Override
    public long getNumSegmentsPrunedByLimit() {
        return this._brokerStats.getLong(StatKey.NUM_SEGMENTS_PRUNED_BY_LIMIT);
    }

    @Override
    public long getNumSegmentsPrunedByValue() {
        return this._brokerStats.getLong(StatKey.NUM_SEGMENTS_PRUNED_BY_VALUE);
    }

    @Override
    public long getBrokerReduceTimeMs() {
        return this._brokerReduceTimeMs;
    }

    public void setBrokerReduceTimeMs(long brokerReduceTimeMs) {
        this._brokerReduceTimeMs = brokerReduceTimeMs;
    }

    @Override
    public long getOfflineThreadCpuTimeNs() {
        return 0L;
    }

    @Override
    public long getRealtimeThreadCpuTimeNs() {
        return 0L;
    }

    @Override
    public long getOfflineSystemActivitiesCpuTimeNs() {
        return 0L;
    }

    @Override
    public long getRealtimeSystemActivitiesCpuTimeNs() {
        return 0L;
    }

    @Override
    public long getOfflineResponseSerializationCpuTimeNs() {
        return 0L;
    }

    @Override
    public long getRealtimeResponseSerializationCpuTimeNs() {
        return 0L;
    }

    @Override
    public long getExplainPlanNumEmptyFilterSegments() {
        return 0L;
    }

    @Override
    public long getExplainPlanNumMatchAllFilterSegments() {
        return 0L;
    }

    @Override
    public Map<String, String> getTraceInfo() {
        return Map.of();
    }

    public void addBrokerStats(StatMap<StatKey> brokerStats) {
        this._brokerStats.merge(brokerStats);
    }

    @Override
    public void setTablesQueried(@NotNull Set<String> tablesQueried) {
        this._tablesQueried = tablesQueried;
    }

    @Override
    @NotNull
    public Set<String> getTablesQueried() {
        return this._tablesQueried;
    }

    public static enum StatKey implements StatMap.Key
    {
        NUM_DOCS_SCANNED(StatMap.Type.LONG),
        TOTAL_DOCS(StatMap.Type.LONG),
        NUM_ENTRIES_SCANNED_IN_FILTER(StatMap.Type.LONG),
        NUM_ENTRIES_SCANNED_POST_FILTER(StatMap.Type.LONG),
        NUM_SEGMENTS_QUERIED(StatMap.Type.INT),
        NUM_SEGMENTS_PROCESSED(StatMap.Type.INT),
        NUM_SEGMENTS_MATCHED(StatMap.Type.INT),
        NUM_CONSUMING_SEGMENTS_QUERIED(StatMap.Type.INT),
        NUM_CONSUMING_SEGMENTS_PROCESSED(StatMap.Type.INT),
        NUM_CONSUMING_SEGMENTS_MATCHED(StatMap.Type.INT),
        MIN_CONSUMING_FRESHNESS_TIME_MS(StatMap.Type.LONG){

            @Override
            public long merge(long value1, long value2) {
                return StatMap.Key.minPositive(value1, value2);
            }
        }
        ,
        NUM_SEGMENTS_PRUNED_BY_SERVER(StatMap.Type.INT),
        NUM_SEGMENTS_PRUNED_INVALID(StatMap.Type.INT),
        NUM_SEGMENTS_PRUNED_BY_LIMIT(StatMap.Type.INT),
        NUM_SEGMENTS_PRUNED_BY_VALUE(StatMap.Type.INT),
        NUM_GROUPS_LIMIT_REACHED(StatMap.Type.BOOLEAN);

        private final StatMap.Type _type;

        private StatKey(StatMap.Type type) {
            this._type = type;
        }

        @Override
        public StatMap.Type getType() {
            return this._type;
        }
    }
}

