/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.tsdb.spi.series.TimeSeries;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBlock;

@InterfaceStability.Evolving
public class PinotBrokerTimeSeriesResponse {
    public static final String SUCCESS_STATUS = "success";
    public static final String ERROR_STATUS = "error";
    public static final String METRIC_NAME_KEY = "__name__";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String _status;
    private Data _data;
    private String _errorType;
    private String _error;

    @JsonCreator
    public PinotBrokerTimeSeriesResponse(@JsonProperty(value="status") String status, @JsonProperty(value="data") Data data, @JsonProperty(value="errorType") String errorType, @JsonProperty(value="error") String error) {
        this._status = status;
        this._data = data;
        this._errorType = errorType;
        this._error = error;
    }

    public String getStatus() {
        return this._status;
    }

    public Data getData() {
        return this._data;
    }

    public String getErrorType() {
        return this._errorType;
    }

    public String getError() {
        return this._error;
    }

    public String serialize() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this);
    }

    public static PinotBrokerTimeSeriesResponse newSuccessResponse(Data data) {
        return new PinotBrokerTimeSeriesResponse(SUCCESS_STATUS, data, null, null);
    }

    public static PinotBrokerTimeSeriesResponse newErrorResponse(String errorType, String errorMessage) {
        return new PinotBrokerTimeSeriesResponse(ERROR_STATUS, Data.EMPTY, errorType, errorMessage);
    }

    public static PinotBrokerTimeSeriesResponse fromTimeSeriesBlock(TimeSeriesBlock seriesBlock) {
        if (seriesBlock.getTimeBuckets() == null) {
            throw new UnsupportedOperationException("Non-bucketed series block not supported yet");
        }
        return PinotBrokerTimeSeriesResponse.convertBucketedSeriesBlock(seriesBlock);
    }

    private static PinotBrokerTimeSeriesResponse convertBucketedSeriesBlock(TimeSeriesBlock seriesBlock) {
        Long[] timeValues = Objects.requireNonNull(seriesBlock.getTimeBuckets()).getTimeBuckets();
        ArrayList<Value> result = new ArrayList<Value>();
        for (List listOfTimeSeries : seriesBlock.getSeriesMap().values()) {
            Preconditions.checkState((!listOfTimeSeries.isEmpty() ? 1 : 0) != 0, (Object)"Received empty time-series");
            TimeSeries anySeries = (TimeSeries)listOfTimeSeries.get(0);
            HashMap<String, String> metricMap = new HashMap<String, String>();
            metricMap.put(METRIC_NAME_KEY, anySeries.getTagsSerialized());
            metricMap.putAll(anySeries.getTagKeyValuesAsMap());
            for (TimeSeries timeSeries : listOfTimeSeries) {
                Object[][] values = new Object[timeValues.length][];
                for (int i = 0; i < timeValues.length; ++i) {
                    Double nullableValue = timeSeries.getDoubleValues()[i];
                    values[i] = new Object[]{timeValues[i], nullableValue == null ? null : ((Object)nullableValue).toString()};
                }
                result.add(new Value(metricMap, values));
            }
        }
        Data data = Data.newMatrix(result);
        return PinotBrokerTimeSeriesResponse.newSuccessResponse(data);
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class Value {
        private final Map<String, String> _metric;
        private final Object[][] _values;

        @JsonCreator
        public Value(@JsonProperty(value="metric") Map<String, String> metric, @JsonProperty(value="values") Object[][] values) {
            this._metric = metric;
            this._values = values;
        }

        public Map<String, String> getMetric() {
            return this._metric;
        }

        public Object[][] getValues() {
            return this._values;
        }
    }

    public static class Data {
        public static final Data EMPTY = new Data("", new ArrayList<Value>());
        private final String _resultType;
        private final List<Value> _result;

        @JsonCreator
        public Data(@JsonProperty(value="resultType") String resultType, @JsonProperty(value="result") List<Value> result) {
            this._resultType = resultType;
            this._result = result;
        }

        public String getResultType() {
            return this._resultType;
        }

        public List<Value> getResult() {
            return this._result;
        }

        public static Data newMatrix(List<Value> result) {
            return new Data("matrix", result);
        }
    }
}

