/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.minion.MinionRequestURLBuilder;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.task.AdhocTaskConfig;
import org.apache.pinot.spi.utils.JsonUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MinionClient {
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientBuilder.create().build();
    private static final String ACCEPT = "accept";
    private static final String APPLICATION_JSON = "application/json";
    private static final String HTTP = "http";
    private static final TypeReference<Map<String, String>> TYPEREF_MAP_STRING_STRING = new TypeReference<Map<String, String>>(){};
    private final String _controllerUrl;
    private final AuthProvider _authProvider;

    public MinionClient(String controllerUrl, AuthProvider authProvider) {
        this._controllerUrl = controllerUrl;
        this._authProvider = authProvider;
    }

    public String getControllerUrl() {
        return this._controllerUrl;
    }

    public Map<String, String> scheduleMinionTasks(@Nullable String taskType, @Nullable String tableNameWithType) throws IOException, HttpException {
        HttpPost httpPost = this.createHttpPostRequest(MinionRequestURLBuilder.baseUrl(this._controllerUrl).forTaskSchedule(taskType, tableNameWithType));
        try (CloseableHttpResponse response = HTTP_CLIENT.execute((ClassicHttpRequest)httpPost);){
            int statusCode = response.getCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode >= 400) {
                throw new HttpException(String.format("Unable to schedule minion tasks. Error code %d, Error message: %s", statusCode, responseString));
            }
            Map map = (Map)JsonUtils.stringToObject((String)responseString, TYPEREF_MAP_STRING_STRING);
            return map;
        }
    }

    public Map<String, String> getTasksStates(String taskType) throws IOException, HttpException {
        HttpGet httpGet = this.createHttpGetRequest(MinionRequestURLBuilder.baseUrl(this._controllerUrl).forTasksStates(taskType));
        try (CloseableHttpResponse response = HTTP_CLIENT.execute((ClassicHttpRequest)httpGet);){
            int statusCode = response.getCode();
            String responseString = IOUtils.toString((InputStream)response.getEntity().getContent());
            if (statusCode >= 400) {
                throw new HttpException(String.format("Unable to get tasks states map. Error code %d, Error message: %s", statusCode, responseString));
            }
            Map map = (Map)JsonUtils.stringToObject((String)responseString, TYPEREF_MAP_STRING_STRING);
            return map;
        }
    }

    public String getTaskState(String taskName) throws IOException, HttpException {
        HttpGet httpGet = this.createHttpGetRequest(MinionRequestURLBuilder.baseUrl(this._controllerUrl).forTaskState(taskName));
        try (CloseableHttpResponse response = HTTP_CLIENT.execute((ClassicHttpRequest)httpGet);){
            int statusCode = response.getCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode >= 400) {
                throw new HttpException(String.format("Unable to get state for task: %s. Error code %d, Error message: %s", taskName, statusCode, responseString));
            }
            String string = responseString;
            return string;
        }
    }

    public Map<String, String> executeTask(AdhocTaskConfig adhocTaskConfig, @Nullable Map<String, String> headers) throws IOException, HttpException {
        HttpPost httpPost = this.createHttpPostRequest(MinionRequestURLBuilder.baseUrl(this._controllerUrl).forTaskExecute());
        httpPost.setEntity((HttpEntity)new StringEntity(adhocTaskConfig.toJsonString()));
        if (headers != null) {
            headers.remove("content-length");
            headers.entrySet().forEach(entry -> httpPost.setHeader((String)entry.getKey(), entry.getValue()));
        }
        try (CloseableHttpResponse response = HTTP_CLIENT.execute((ClassicHttpRequest)httpPost);){
            int statusCode = response.getCode();
            String responseString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
            if (statusCode >= 400) {
                throw new HttpException(String.format("Unable to get tasks states map. Error code %d, Error message: %s", statusCode, responseString));
            }
            Map map = (Map)JsonUtils.stringToObject((String)responseString, TYPEREF_MAP_STRING_STRING);
            return map;
        }
    }

    private HttpGet createHttpGetRequest(String uri) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader(ACCEPT, (Object)APPLICATION_JSON);
        AuthProviderUtils.toRequestHeaders(this._authProvider).forEach(arg_0 -> ((HttpGet)httpGet).setHeader(arg_0));
        return httpGet;
    }

    private HttpPost createHttpPostRequest(String uri) {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader(ACCEPT, (Object)APPLICATION_JSON);
        AuthProviderUtils.toRequestHeaders(this._authProvider).forEach(arg_0 -> ((HttpPost)httpPost).setHeader(arg_0));
        return httpPost;
    }
}

