/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.pinot.common.minion.TaskGeneratorMostRecentRunInfo;
import org.apache.pinot.common.minion.TaskManagerStatusCache;

public class InMemoryTaskManagerStatusCache
implements TaskManagerStatusCache<TaskGeneratorMostRecentRunInfo> {
    private final ConcurrentHashMap<TaskGeneratorCacheKey, TaskGeneratorMostRecentRunInfo> _cacheMap = new ConcurrentHashMap();

    @Override
    public TaskGeneratorMostRecentRunInfo fetchTaskGeneratorInfo(String tableNameWithType, String taskType) {
        return this._cacheMap.get(new TaskGeneratorCacheKey(tableNameWithType, taskType));
    }

    @Override
    public void saveTaskGeneratorInfo(String tableNameWithType, String taskType, Consumer<TaskGeneratorMostRecentRunInfo> taskGeneratorMostRecentRunInfoUpdater) {
        this._cacheMap.compute(new TaskGeneratorCacheKey(tableNameWithType, taskType), (k, v) -> {
            if (v == null) {
                v = TaskGeneratorMostRecentRunInfo.newInstance(tableNameWithType, taskType);
            }
            taskGeneratorMostRecentRunInfoUpdater.accept((TaskGeneratorMostRecentRunInfo)v);
            return v;
        });
    }

    @Override
    public void deleteTaskGeneratorInfo(String tableNameWithType, String taskType) {
        this._cacheMap.remove(new TaskGeneratorCacheKey(tableNameWithType, taskType));
    }

    private static class TaskGeneratorCacheKey {
        final String _tableNameWithType;
        final String _taskType;

        private TaskGeneratorCacheKey(String tableNameWithType, String taskType) {
            this._tableNameWithType = tableNameWithType;
            this._taskType = taskType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskGeneratorCacheKey that = (TaskGeneratorCacheKey)o;
            return this._tableNameWithType.equals(that._tableNameWithType) && this._taskType.equals(that._taskType);
        }

        public int hashCode() {
            return Objects.hash(this._tableNameWithType, this._taskType);
        }
    }
}

