/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerTimer;
import org.apache.pinot.spi.metrics.NoopPinotMetricsRegistry;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

public class ControllerMetrics
extends AbstractMetrics<AbstractMetrics.QueryPhase, ControllerMeter, ControllerGauge, ControllerTimer> {
    private static final ControllerMetrics NOOP = new ControllerMetrics((PinotMetricsRegistry)new NoopPinotMetricsRegistry());
    private static final AtomicReference<ControllerMetrics> CONTROLLER_METRICS_INSTANCE = new AtomicReference<ControllerMetrics>(NOOP);

    public static boolean register(ControllerMetrics controllerMetrics) {
        return CONTROLLER_METRICS_INSTANCE.compareAndSet(NOOP, controllerMetrics);
    }

    public static ControllerMetrics get() {
        return CONTROLLER_METRICS_INSTANCE.get();
    }

    public ControllerMetrics(PinotMetricsRegistry metricsRegistry) {
        this("pinot.controller.", metricsRegistry);
    }

    public ControllerMetrics(String prefix, PinotMetricsRegistry metricsRegistry) {
        super(prefix, metricsRegistry, ControllerMetrics.class);
    }

    protected AbstractMetrics.QueryPhase[] getQueryPhases() {
        return new AbstractMetrics.QueryPhase[0];
    }

    protected ControllerMeter[] getMeters() {
        return ControllerMeter.values();
    }

    protected ControllerGauge[] getGauges() {
        return ControllerGauge.values();
    }
}

