/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum BrokerMeter implements AbstractMetrics.Meter
{
    UNCAUGHT_GET_EXCEPTIONS("exceptions", true),
    UNCAUGHT_POST_EXCEPTIONS("exceptions", true),
    HEALTHCHECK_BAD_CALLS("healthcheck", true),
    HEALTHCHECK_OK_CALLS("healthcheck", true),
    QUERIES("queries", false),
    QUERIES_GLOBAL("queries", true),
    MULTI_STAGE_QUERIES_GLOBAL("queries", true),
    MULTI_STAGE_QUERIES("queries", false),
    SINGLE_STAGE_QUERIES_INVALID_MULTI_STAGE("queries", true),
    TIME_SERIES_GLOBAL_QUERIES("queries", true),
    TIME_SERIES_GLOBAL_QUERIES_FAILED("queries", true),
    QUERY_REJECTED_EXCEPTIONS("exceptions", true),
    REQUEST_COMPILATION_EXCEPTIONS("exceptions", true),
    RESOURCE_MISSING_EXCEPTIONS("exceptions", true),
    QUERY_VALIDATION_EXCEPTIONS("exceptions", false),
    UNKNOWN_COLUMN_EXCEPTIONS("exceptions", false),
    QUERIES_KILLED("query", true),
    NO_SERVER_FOUND_EXCEPTIONS("exceptions", false),
    REQUEST_TIMEOUT_BEFORE_SCATTERED_EXCEPTIONS("exceptions", false),
    REQUEST_CHANNEL_LOCK_TIMEOUT_EXCEPTIONS("exceptions", false),
    REQUEST_SEND_EXCEPTIONS("exceptions", false),
    RESPONSE_FETCH_EXCEPTIONS("exceptions", false),
    DATA_TABLE_DESERIALIZATION_EXCEPTIONS("exceptions", false),
    RESPONSE_MERGE_EXCEPTIONS("exceptions", false),
    HEAP_CRITICAL_LEVEL_EXCEEDED("count", true),
    HEAP_PANIC_LEVEL_EXCEEDED("count", true),
    BROKER_RESPONSES_WITH_PROCESSING_EXCEPTIONS("badResponses", false),
    BROKER_RESPONSES_WITH_UNAVAILABLE_SEGMENTS("badResponses", false),
    BROKER_RESPONSES_WITH_PARTIAL_SERVERS_RESPONDED("badResponses", false),
    SECONDARY_WORKLOAD_BROKER_RESPONSES_WITH_PARTIAL_SERVERS_RESPONDED("badResponses", false),
    BROKER_RESPONSES_WITH_TIMEOUTS("badResponses", false),
    SECONDARY_WORKLOAD_BROKER_RESPONSES_WITH_TIMEOUTS("badResponses", false),
    BROKER_RESPONSES_WITH_NUM_GROUPS_LIMIT_REACHED("badResponses", false),
    DOCUMENTS_SCANNED("documents", false),
    ENTRIES_SCANNED_IN_FILTER("documents", false),
    ENTRIES_SCANNED_POST_FILTER("documents", false),
    NUM_RESIZES("numResizes", false),
    HELIX_ZOOKEEPER_RECONNECTS("reconnects", true),
    REQUEST_DROPPED_DUE_TO_ACCESS_ERROR("requestsDropped", false),
    GROUP_BY_SIZE("queries", false),
    TOTAL_SERVER_RESPONSE_SIZE("queries", false),
    QUERY_QUOTA_EXCEEDED("exceptions", false),
    NO_SERVING_HOST_FOR_SEGMENT("badResponses", false),
    SERVER_MISSING_FOR_ROUTING("badResponses", false),
    NETTY_CONNECTION_REQUESTS_SENT("nettyConnection", true),
    NETTY_CONNECTION_BYTES_SENT("nettyConnection", true),
    NETTY_CONNECTION_BYTES_RECEIVED("nettyConnection", true),
    PROACTIVE_CLUSTER_CHANGE_CHECK("proactiveClusterChangeCheck", true),
    DIRECT_MEMORY_OOM("directMemoryOOMCount", true),
    QUERIES_WITH_JOINS("queries", true),
    JOIN_COUNT("queries", true),
    QUERIES_WITH_WINDOW("queries", true),
    WINDOW_COUNT("queries", true),
    CURSOR_QUERIES_GLOBAL("queries", true),
    CURSOR_WRITE_EXCEPTION("exceptions", true),
    CURSOR_READ_EXCEPTION("exceptions", true),
    CURSOR_RESPONSE_STORE_SIZE("bytes", true);

    private final String _brokerMeterName;
    private final String _unit;
    private final boolean _global;

    private BrokerMeter(String unit, boolean global) {
        this._unit = unit;
        this._global = global;
        this._brokerMeterName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getMeterName() {
        return this._brokerMeterName;
    }

    @Override
    public String getUnit() {
        return this._unit;
    }

    @Override
    public boolean isGlobal() {
        return this._global;
    }
}

