/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class DatabaseConfigRefreshMessage
extends Message {
    public static final String REFRESH_DATABASE_CONFIG_MSG_SUB_TYPE = "REFRESH_DATABASE_CONFIG";
    private static final String DATABASE_NAME_KEY = "databaseName";

    public DatabaseConfigRefreshMessage(String databaseName) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setMsgSubType(REFRESH_DATABASE_CONFIG_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setSimpleField(DATABASE_NAME_KEY, databaseName);
    }

    public DatabaseConfigRefreshMessage(Message message) {
        super(message.getRecord());
        if (!message.getMsgSubType().equals(REFRESH_DATABASE_CONFIG_MSG_SUB_TYPE)) {
            throw new IllegalArgumentException("Invalid message subtype:" + message.getMsgSubType());
        }
    }

    public String getDatabaseName() {
        return this.getRecord().getSimpleField(DATABASE_NAME_KEY);
    }
}

