/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.http;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.apache.pinot.common.http.MultiHttpRequestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiHttpRequest.class);
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;

    public MultiHttpRequest(Executor executor, HttpClientConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public CompletionService<MultiHttpRequestResponse> executeGet(List<String> urls, @Nullable Map<String, String> requestHeaders, int timeoutMs) {
        ArrayList<Pair<String, String>> urlsAndRequestBodies = new ArrayList<Pair<String, String>>();
        urls.forEach(url -> urlsAndRequestBodies.add(Pair.of((Object)url, (Object)"")));
        return this.execute(urlsAndRequestBodies, requestHeaders, timeoutMs, "GET", HttpGet::new);
    }

    public CompletionService<MultiHttpRequestResponse> executePost(List<Pair<String, String>> urlsAndRequestBodies, @Nullable Map<String, String> requestHeaders, int timeoutMs) {
        return this.execute(urlsAndRequestBodies, requestHeaders, timeoutMs, "POST", HttpPost::new);
    }

    public <T extends HttpUriRequestBase> CompletionService<MultiHttpRequestResponse> execute(List<Pair<String, String>> urlsAndRequestBodies, @Nullable Map<String, String> requestHeaders, int timeoutMs, String httpMethodName, Function<String, T> httpRequestBaseSupplier) {
        Timeout timeout = Timeout.of((long)timeoutMs, (TimeUnit)TimeUnit.MILLISECONDS);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeout).setResponseTimeout(timeout).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this._connectionManager).setDefaultRequestConfig(defaultRequestConfig);
        ExecutorCompletionService<MultiHttpRequestResponse> completionService = new ExecutorCompletionService<MultiHttpRequestResponse>(this._executor);
        CloseableHttpClient client = httpClientBuilder.build();
        for (Pair<String, String> pair : urlsAndRequestBodies) {
            completionService.submit(() -> {
                String url = (String)pair.getLeft();
                String body = (String)pair.getRight();
                HttpUriRequestBase httpMethod = (HttpUriRequestBase)httpRequestBaseSupplier.apply(url);
                if (httpMethod instanceof HttpPost) {
                    ((HttpPost)httpMethod).setEntity((HttpEntity)new StringEntity(body));
                }
                if (requestHeaders != null) {
                    requestHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequestBase)httpMethod).setHeader(arg_0, arg_1));
                }
                CloseableHttpResponse response = null;
                try {
                    response = client.execute((ClassicHttpRequest)httpMethod);
                    httpMethod.setAbsoluteRequestUri(true);
                    return new MultiHttpRequestResponse(URI.create(httpMethod.getRequestUri()), response);
                }
                catch (IOException ex) {
                    if (response != null) {
                        String error = EntityUtils.toString((HttpEntity)response.getEntity());
                        LOGGER.warn("Caught '{}' while executing: {} on URL: {}", new Object[]{error, httpMethodName, url});
                    } else {
                        LOGGER.warn("Caught '{}' while executing: {} on URL: {}", new Object[]{ex, httpMethodName, url});
                    }
                    throw ex;
                }
            });
        }
        return completionService;
    }
}

