/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.comparison;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.scalar.comparison.PolymorphicComparisonScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction
public class NotEqualsScalarFunction
extends PolymorphicComparisonScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);
    private static final FunctionInfo DOUBLE_NOT_EQUALS_WITH_TOLERANCE;

    @Override
    protected FunctionInfo functionInfoForType(DataSchema.ColumnDataType argumentType) {
        return TYPE_FUNCTION_INFO_MAP.get((Object)argumentType);
    }

    @Override
    protected FunctionInfo defaultFunctionInfo() {
        return DOUBLE_NOT_EQUALS_WITH_TOLERANCE;
    }

    @Override
    public String getName() {
        return "notEquals";
    }

    public static boolean intNotEquals(int a, int b) {
        return a != b;
    }

    public static boolean longNotEquals(long a, long b) {
        return a != b;
    }

    public static boolean floatNotEquals(float a, float b) {
        return a != b;
    }

    public static boolean doubleNotEquals(double a, double b) {
        return a != b;
    }

    public static boolean doubleNotEqualsWithTolerance(double a, double b) {
        return Math.abs(a - b) >= 1.0E-7;
    }

    public static boolean bigDecimalNotEquals(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) != 0;
    }

    public static boolean stringNotEquals(String a, String b) {
        return !a.equals(b);
    }

    public static boolean bytesNotEquals(byte[] a, byte[] b) {
        return !Arrays.equals(a, b);
    }

    public static boolean objectNotEquals(Object a, Object b) {
        return !Objects.equals(a, b);
    }

    public static boolean intArrayNotEquals(int[] a, int[] b) {
        return !Arrays.equals(a, b);
    }

    public static boolean longArrayNotEquals(long[] a, long[] b) {
        return !Arrays.equals(a, b);
    }

    public static boolean floatArrayNotEquals(float[] a, float[] b) {
        return !Arrays.equals(a, b);
    }

    public static boolean doubleArrayNotEquals(double[] a, double[] b) {
        return !Arrays.equals(a, b);
    }

    public static boolean stringArrayNotEquals(String[] a, String[] b) {
        return !Arrays.equals(a, b);
    }

    public static boolean bytesArrayNotEquals(byte[][] a, byte[][] b) {
        return !Arrays.deepEquals((Object[])a, (Object[])b);
    }

    static {
        try {
            DOUBLE_NOT_EQUALS_WITH_TOLERANCE = new FunctionInfo(NotEqualsScalarFunction.class.getMethod("doubleNotEqualsWithTolerance", Double.TYPE, Double.TYPE), NotEqualsScalarFunction.class, false);
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("intNotEquals", Integer.TYPE, Integer.TYPE), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("longNotEquals", Long.TYPE, Long.TYPE), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("floatNotEquals", Float.TYPE, Float.TYPE), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("doubleNotEquals", Double.TYPE, Double.TYPE), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BIG_DECIMAL, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("bigDecimalNotEquals", BigDecimal.class, BigDecimal.class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("stringNotEquals", String.class, String.class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BYTES, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("bytesNotEquals", byte[].class, byte[].class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.OBJECT, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("objectNotEquals", Object.class, Object.class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT_ARRAY, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("intArrayNotEquals", int[].class, int[].class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG_ARRAY, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("longArrayNotEquals", long[].class, long[].class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT_ARRAY, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("floatArrayNotEquals", float[].class, float[].class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE_ARRAY, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("doubleArrayNotEquals", double[].class, double[].class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING_ARRAY, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("stringArrayNotEquals", String[].class, String[].class), NotEqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BYTES_ARRAY, new FunctionInfo(NotEqualsScalarFunction.class.getMethod("bytesArrayNotEquals", byte[][].class, byte[][].class), NotEqualsScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

