/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.comparison;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.scalar.comparison.PolymorphicComparisonScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction
public class LessThanScalarFunction
extends PolymorphicComparisonScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);

    @Override
    protected FunctionInfo functionInfoForType(DataSchema.ColumnDataType argumentType) {
        return TYPE_FUNCTION_INFO_MAP.get((Object)argumentType);
    }

    @Override
    public String getName() {
        return "lessThan";
    }

    public static boolean intLessThan(int a, int b) {
        return a < b;
    }

    public static boolean longLessThan(long a, long b) {
        return a < b;
    }

    public static boolean floatLessThan(float a, float b) {
        return a < b;
    }

    public static boolean doubleLessThan(double a, double b) {
        return a < b;
    }

    public static boolean bigDecimalLessThan(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) < 0;
    }

    public static boolean stringLessThan(String a, String b) {
        return a.compareTo(b) < 0;
    }

    static {
        try {
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT, new FunctionInfo(LessThanScalarFunction.class.getMethod("intLessThan", Integer.TYPE, Integer.TYPE), LessThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(LessThanScalarFunction.class.getMethod("longLessThan", Long.TYPE, Long.TYPE), LessThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT, new FunctionInfo(LessThanScalarFunction.class.getMethod("floatLessThan", Float.TYPE, Float.TYPE), LessThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(LessThanScalarFunction.class.getMethod("doubleLessThan", Double.TYPE, Double.TYPE), LessThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BIG_DECIMAL, new FunctionInfo(LessThanScalarFunction.class.getMethod("bigDecimalLessThan", BigDecimal.class, BigDecimal.class), LessThanScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING, new FunctionInfo(LessThanScalarFunction.class.getMethod("stringLessThan", String.class, String.class), LessThanScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

