/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.comparison;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.scalar.comparison.PolymorphicComparisonScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction
public class LessThanOrEqualScalarFunction
extends PolymorphicComparisonScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);

    @Override
    protected FunctionInfo functionInfoForType(DataSchema.ColumnDataType argumentType) {
        return TYPE_FUNCTION_INFO_MAP.get((Object)argumentType);
    }

    @Override
    public String getName() {
        return "lessThanOrEqual";
    }

    public static boolean intLessThanOrEqual(int a, int b) {
        return a <= b;
    }

    public static boolean longLessThanOrEqual(long a, long b) {
        return a <= b;
    }

    public static boolean floatLessThanOrEqual(float a, float b) {
        return a <= b;
    }

    public static boolean doubleLessThanOrEqual(double a, double b) {
        return a <= b;
    }

    public static boolean bigDecimalLessThanOrEqual(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) <= 0;
    }

    public static boolean stringLessThanOrEqual(String a, String b) {
        return a.compareTo(b) <= 0;
    }

    static {
        try {
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT, new FunctionInfo(LessThanOrEqualScalarFunction.class.getMethod("intLessThanOrEqual", Integer.TYPE, Integer.TYPE), LessThanOrEqualScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(LessThanOrEqualScalarFunction.class.getMethod("longLessThanOrEqual", Long.TYPE, Long.TYPE), LessThanOrEqualScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT, new FunctionInfo(LessThanOrEqualScalarFunction.class.getMethod("floatLessThanOrEqual", Float.TYPE, Float.TYPE), LessThanOrEqualScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(LessThanOrEqualScalarFunction.class.getMethod("doubleLessThanOrEqual", Double.TYPE, Double.TYPE), LessThanOrEqualScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BIG_DECIMAL, new FunctionInfo(LessThanOrEqualScalarFunction.class.getMethod("bigDecimalLessThanOrEqual", BigDecimal.class, BigDecimal.class), LessThanOrEqualScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING, new FunctionInfo(LessThanOrEqualScalarFunction.class.getMethod("stringLessThanOrEqual", String.class, String.class), LessThanOrEqualScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

