/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.comparison;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.PinotScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction
public class BetweenScalarFunction
implements PinotScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);

    @Override
    public String getName() {
        return "between";
    }

    @Override
    @Nullable
    public FunctionInfo getFunctionInfo(DataSchema.ColumnDataType[] argumentTypes) {
        if (argumentTypes.length != 3) {
            return null;
        }
        if (argumentTypes[0].getStoredType() != argumentTypes[1].getStoredType() || argumentTypes[0].getStoredType() != argumentTypes[2].getStoredType()) {
            return TYPE_FUNCTION_INFO_MAP.get((Object)DataSchema.ColumnDataType.DOUBLE);
        }
        return TYPE_FUNCTION_INFO_MAP.get((Object)argumentTypes[0].getStoredType());
    }

    @Override
    @Nullable
    public FunctionInfo getFunctionInfo(int numArguments) {
        if (numArguments != 3) {
            return null;
        }
        return TYPE_FUNCTION_INFO_MAP.get((Object)DataSchema.ColumnDataType.DOUBLE);
    }

    public static boolean intBetween(int val, int lower, int upper) {
        return val >= lower && val <= upper;
    }

    public static boolean longBetween(long val, long lower, long upper) {
        return val >= lower && val <= upper;
    }

    public static boolean floatBetween(float val, float lower, float upper) {
        return val >= lower && val <= upper;
    }

    public static boolean doubleBetween(double val, double lower, double upper) {
        return val >= lower && val <= upper;
    }

    public static boolean bigDecimalBetween(BigDecimal val, BigDecimal lower, BigDecimal upper) {
        return val.compareTo(lower) >= 0 && val.compareTo(upper) <= 0;
    }

    public static boolean stringBetween(String val, String lower, String upper) {
        return val.compareTo(lower) >= 0 && val.compareTo(upper) <= 0;
    }

    static {
        try {
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT, new FunctionInfo(BetweenScalarFunction.class.getMethod("intBetween", Integer.TYPE, Integer.TYPE, Integer.TYPE), BetweenScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(BetweenScalarFunction.class.getMethod("longBetween", Long.TYPE, Long.TYPE, Long.TYPE), BetweenScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT, new FunctionInfo(BetweenScalarFunction.class.getMethod("floatBetween", Float.TYPE, Float.TYPE, Float.TYPE), BetweenScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(BetweenScalarFunction.class.getMethod("doubleBetween", Double.TYPE, Double.TYPE, Double.TYPE), BetweenScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BIG_DECIMAL, new FunctionInfo(BetweenScalarFunction.class.getMethod("bigDecimalBetween", BigDecimal.class, BigDecimal.class, BigDecimal.class), BetweenScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING, new FunctionInfo(BetweenScalarFunction.class.getMethod("stringBetween", String.class, String.class, String.class), BetweenScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

