/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.arithmetic;

import javax.annotation.Nullable;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.PinotScalarFunction;
import org.apache.pinot.common.utils.DataSchema;

public abstract class PolymorphicBinaryArithmeticScalarFunction
implements PinotScalarFunction {
    @Override
    @Nullable
    public FunctionInfo getFunctionInfo(DataSchema.ColumnDataType[] argumentTypes) {
        if (argumentTypes.length != 2) {
            return null;
        }
        return this.functionInfoForTypes(argumentTypes[0].getStoredType(), argumentTypes[1].getStoredType());
    }

    @Override
    @Nullable
    public FunctionInfo getFunctionInfo(int numArguments) {
        if (numArguments != 2) {
            return null;
        }
        return this.functionInfoForType(DataSchema.ColumnDataType.DOUBLE);
    }

    private FunctionInfo functionInfoForTypes(DataSchema.ColumnDataType argumentType1, DataSchema.ColumnDataType argumentType2) {
        if (!(argumentType1 != DataSchema.ColumnDataType.LONG && argumentType1 != DataSchema.ColumnDataType.INT || argumentType2 != DataSchema.ColumnDataType.LONG && argumentType2 != DataSchema.ColumnDataType.INT)) {
            return this.functionInfoForType(DataSchema.ColumnDataType.LONG);
        }
        return this.functionInfoForType(DataSchema.ColumnDataType.DOUBLE);
    }

    protected abstract FunctionInfo functionInfoForType(DataSchema.ColumnDataType var1);
}

