/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.arithmetic;

import java.util.EnumMap;
import java.util.Map;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.scalar.arithmetic.PolymorphicBinaryArithmeticScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction(names={"add", "plus"})
public class PlusScalarFunction
extends PolymorphicBinaryArithmeticScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);

    @Override
    protected FunctionInfo functionInfoForType(DataSchema.ColumnDataType argumentType) {
        FunctionInfo functionInfo = TYPE_FUNCTION_INFO_MAP.get((Object)argumentType);
        return functionInfo != null ? functionInfo : TYPE_FUNCTION_INFO_MAP.get((Object)DataSchema.ColumnDataType.DOUBLE);
    }

    @Override
    public String getName() {
        return "plus";
    }

    public static long longPlus(long a, long b) {
        return a + b;
    }

    public static double doublePlus(double a, double b) {
        return a + b;
    }

    static {
        try {
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(PlusScalarFunction.class.getMethod("longPlus", Long.TYPE, Long.TYPE), PlusScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(PlusScalarFunction.class.getMethod("doublePlus", Double.TYPE, Double.TYPE), PlusScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

