/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import javax.annotation.Nullable;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class ObjectFunctions {
    private ObjectFunctions() {
    }

    @ScalarFunction(nullableParameters=true)
    public static boolean isNull(@Nullable Object obj) {
        return obj == null;
    }

    @ScalarFunction(nullableParameters=true)
    public static boolean isNotNull(@Nullable Object obj) {
        return !ObjectFunctions.isNull(obj);
    }

    @ScalarFunction(nullableParameters=true)
    public static boolean isDistinctFrom(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 == null && obj2 == null) {
            return false;
        }
        if (obj1 == null || obj2 == null) {
            return true;
        }
        return !obj1.equals(obj2);
    }

    @ScalarFunction(nullableParameters=true)
    public static boolean isNotDistinctFrom(@Nullable Object obj1, @Nullable Object obj2) {
        return !ObjectFunctions.isDistinctFrom(obj1, obj2);
    }

    @Nullable
    @ScalarFunction(nullableParameters=true, isVarArg=true)
    public static Object coalesce(Object ... objects) {
        for (Object o : objects) {
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Nullable
    @ScalarFunction(names={"case", "caseWhen"}, nullableParameters=true, isVarArg=true)
    public static Object caseWhen(Object ... objs) {
        for (int i = 0; i < objs.length - 1; i += 2) {
            if (!Boolean.TRUE.equals(objs[i])) continue;
            return objs[i + 1];
        }
        return objs.length % 2 == 0 ? null : objs[objs.length - 1];
    }

    @Nullable
    @ScalarFunction(nullableParameters=true)
    public static Object nullIf(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 == null) {
            return null;
        }
        return obj1.equals(obj2) ? null : obj1;
    }
}

