/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.sql.Timestamp;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.function.DateTimePatternHandler;
import org.apache.pinot.common.function.DateTimeUtils;
import org.apache.pinot.common.function.TimeZoneKey;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class DateTimeFunctions {
    private DateTimeFunctions() {
    }

    @ScalarFunction
    public static long toEpochSeconds(long millis) {
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @ScalarFunction
    public static long[] toEpochSecondsMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochSeconds(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochMinutes(long millis) {
        return TimeUnit.MILLISECONDS.toMinutes(millis);
    }

    @ScalarFunction
    public static long[] toEpochMinutesMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochMinutes(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochHours(long millis) {
        return TimeUnit.MILLISECONDS.toHours(millis);
    }

    @ScalarFunction
    public static long[] toEpochHoursMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochHours(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochDays(long millis) {
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarFunction
    public static long[] toEpochDaysMV(long[] millis) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochDays(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochSecondsRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long[] toEpochSecondsRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochSecondsRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochMinutesRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long[] toEpochMinutesRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochMinutesRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochHoursRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toHours(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long[] toEpochHoursRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochHoursRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochDaysRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toDays(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long[] toEpochDaysRoundedMV(long[] millis, long roundToNearest) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochDaysRounded(millis[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochSecondsBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / bucket;
    }

    @ScalarFunction
    public static long[] toEpochSecondsBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochSecondsBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochMinutesBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / bucket;
    }

    @ScalarFunction
    public static long[] toEpochMinutesBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochMinutesBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochHoursBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toHours(millis) / bucket;
    }

    @ScalarFunction
    public static long[] toEpochHoursBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochHoursBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static long toEpochDaysBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toDays(millis) / bucket;
    }

    @ScalarFunction
    public static long[] toEpochDaysBucketMV(long[] millis, long bucket) {
        long[] results = new long[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toEpochDaysBucket(millis[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochSeconds(long seconds) {
        return TimeUnit.SECONDS.toMillis(seconds);
    }

    @ScalarFunction
    public static long[] fromEpochSecondsMV(long[] seconds) {
        long[] results = new long[seconds.length];
        for (int i = 0; i < seconds.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochSeconds(seconds[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochMinutes(long minutes) {
        return TimeUnit.MINUTES.toMillis(minutes);
    }

    @ScalarFunction
    public static long[] fromEpochMinutesMV(long[] minutes) {
        long[] results = new long[minutes.length];
        for (int i = 0; i < minutes.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochMinutes(minutes[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochHours(long hours) {
        return TimeUnit.HOURS.toMillis(hours);
    }

    @ScalarFunction
    public static long[] fromEpochHoursMV(long[] hours) {
        long[] results = new long[hours.length];
        for (int i = 0; i < hours.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochHours(hours[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochDays(long days) {
        return TimeUnit.DAYS.toMillis(days);
    }

    @ScalarFunction
    public static long[] fromEpochDaysMV(long[] days) {
        long[] results = new long[days.length];
        for (int i = 0; i < days.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochDays(days[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochSecondsBucket(long seconds, long bucket) {
        return TimeUnit.SECONDS.toMillis(seconds * bucket);
    }

    @ScalarFunction
    public static long[] fromEpochSecondsBucketMV(long[] seconds, long bucket) {
        long[] results = new long[seconds.length];
        for (int i = 0; i < seconds.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochSecondsBucket(seconds[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochMinutesBucket(long minutes, long bucket) {
        return TimeUnit.MINUTES.toMillis(minutes * bucket);
    }

    @ScalarFunction
    public static long[] fromEpochMinutesBucketMV(long[] minutes, long bucket) {
        long[] results = new long[minutes.length];
        for (int i = 0; i < minutes.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochMinutesBucket(minutes[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochHoursBucket(long hours, long bucket) {
        return TimeUnit.HOURS.toMillis(hours * bucket);
    }

    @ScalarFunction
    public static long[] fromEpochHoursBucketMV(long[] hours, long bucket) {
        long[] results = new long[hours.length];
        for (int i = 0; i < hours.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochHoursBucket(hours[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static long fromEpochDaysBucket(long days, long bucket) {
        return TimeUnit.DAYS.toMillis(days * bucket);
    }

    @ScalarFunction
    public static long[] fromEpochDaysBucketMV(long[] days, long bucket) {
        long[] results = new long[days.length];
        for (int i = 0; i < days.length; ++i) {
            results[i] = DateTimeFunctions.fromEpochDaysBucket(days[i], bucket);
        }
        return results;
    }

    @ScalarFunction
    public static Timestamp toTimestamp(long millis) {
        return new Timestamp(millis);
    }

    @ScalarFunction
    public static Timestamp[] toTimestampMV(long[] millis) {
        Timestamp[] results = new Timestamp[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toTimestamp(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long fromTimestamp(Timestamp timestamp) {
        return timestamp.getTime();
    }

    @ScalarFunction
    public static long[] fromTimestampMV(Timestamp[] timestamp) {
        long[] results = new long[timestamp.length];
        for (int i = 0; i < timestamp.length; ++i) {
            results[i] = DateTimeFunctions.fromTimestamp(timestamp[i]);
        }
        return results;
    }

    @ScalarFunction
    public static String toDateTime(long millis, String pattern) {
        return DateTimePatternHandler.parseEpochMillisToDateTimeString(millis, pattern);
    }

    @ScalarFunction
    public static String[] toDateTimeMV(long[] millis, String pattern) {
        String[] results = new String[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toDateTime(millis[i], pattern);
        }
        return results;
    }

    @ScalarFunction
    public static String toDateTime(long millis, String pattern, String timezoneId) {
        return DateTimePatternHandler.parseEpochMillisToDateTimeString(millis, pattern, timezoneId);
    }

    @ScalarFunction
    public static String[] toDateTimeMV(long[] millis, String pattern, String timezoneId) {
        String[] results = new String[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.toDateTime(millis[i], pattern, timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static long fromDateTime(String dateTimeString, String pattern) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern);
    }

    @ScalarFunction
    public static long[] fromDateTimeMV(String[] dateTimeString, String pattern) {
        long[] results = new long[dateTimeString.length];
        for (int i = 0; i < dateTimeString.length; ++i) {
            results[i] = DateTimeFunctions.fromDateTime(dateTimeString[i], pattern);
        }
        return results;
    }

    @ScalarFunction
    public static long fromDateTime(String dateTimeString, String pattern, String timeZoneId) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern, timeZoneId);
    }

    @ScalarFunction
    public static long fromDateTime(String dateTimeString, String pattern, String timeZoneId, long defaultVal) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern, timeZoneId, defaultVal);
    }

    @ScalarFunction
    public static long[] fromDateTimeMV(String[] dateTimeString, String pattern, String timeZoneId) {
        long[] results = new long[dateTimeString.length];
        for (int i = 0; i < dateTimeString.length; ++i) {
            results[i] = DateTimeFunctions.fromDateTime(dateTimeString[i], pattern, timeZoneId);
        }
        return results;
    }

    @ScalarFunction
    public static long round(long timeValue, long roundToNearest) {
        return timeValue / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long[] roundMV(long[] timeValue, long roundToNearest) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.round(timeValue[i], roundToNearest);
        }
        return results;
    }

    @ScalarFunction
    public static long now() {
        return System.currentTimeMillis();
    }

    @ScalarFunction
    public static long ago(String periodString) {
        Duration period = Duration.parse(periodString);
        return System.currentTimeMillis() - period.toMillis();
    }

    @ScalarFunction
    public static long[] agoMV(String[] periodString) {
        long[] results = new long[periodString.length];
        for (int i = 0; i < periodString.length; ++i) {
            results[i] = DateTimeFunctions.ago(periodString[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int timezoneHour(String timezoneId) {
        return DateTimeFunctions.timezoneHour(timezoneId, 0L);
    }

    @ScalarFunction
    public static int[] timezoneHourMV(String[] timezoneId) {
        int[] results = new int[timezoneId.length];
        for (int i = 0; i < timezoneId.length; ++i) {
            results[i] = DateTimeFunctions.timezoneHour(timezoneId[i], 0L);
        }
        return results;
    }

    @ScalarFunction
    public static int timezoneHour(String timezoneId, long millis) {
        return (int)TimeUnit.MILLISECONDS.toHours(DateTimeZone.forID((String)timezoneId).getOffset(millis));
    }

    @ScalarFunction
    public static int[] timezoneHourMV(String timezoneId, long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.timezoneHour(timezoneId, millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int timezoneMinute(String timezoneId) {
        return DateTimeFunctions.timezoneMinute(timezoneId, 0L);
    }

    @ScalarFunction
    public static int[] timezoneMinuteMV(String[] timezoneId) {
        int[] results = new int[timezoneId.length];
        for (int i = 0; i < timezoneId.length; ++i) {
            results[i] = DateTimeFunctions.timezoneMinute(timezoneId[i], 0L);
        }
        return results;
    }

    @ScalarFunction
    public static int timezoneMinute(String timezoneId, long millis) {
        return (int)TimeUnit.MILLISECONDS.toMinutes(DateTimeZone.forID((String)timezoneId).getOffset(millis)) % 60;
    }

    @ScalarFunction
    public static int[] timezoneMinuteMV(String timezoneId, long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.timezoneMinute(timezoneId, millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int year(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getYear();
    }

    @ScalarFunction
    public static int[] yearMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.year(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int year(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getYear();
    }

    @ScalarFunction
    public static int[] yearMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.year(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"yearOfWeek", "yow"})
    public static int yearOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekyear();
    }

    @ScalarFunction(names={"yearOfWeekMV", "yowMV"})
    public static int[] yearOfWeekMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.yearOfWeek(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"yearOfWeek", "yow"})
    public static int yearOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekyear();
    }

    @ScalarFunction(names={"yearOfWeekMV", "yowMV"})
    public static int[] yearOfWeekMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.yearOfWeek(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int quarter(long millis) {
        return (DateTimeFunctions.month(millis) - 1) / 3 + 1;
    }

    @ScalarFunction
    public static int[] quarterMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.quarter(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int quarter(long millis, String timezoneId) {
        return (DateTimeFunctions.month(millis, timezoneId) - 1) / 3 + 1;
    }

    @ScalarFunction
    public static int[] quarterMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.quarter(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"month", "monthOfYear"})
    public static int month(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMonthOfYear();
    }

    @ScalarFunction(names={"monthMV", "monthOfYearMV"})
    public static int[] monthMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.month(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"month", "monthOfYear"})
    public static int month(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMonthOfYear();
    }

    @ScalarFunction(names={"monthMV", "monthOfYearMV"})
    public static int[] monthMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.month(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"week", "weekOfYear"})
    public static int week(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekOfWeekyear();
    }

    @ScalarFunction(names={"weekMV", "weekOfYearMV"})
    public static int[] weekMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.week(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"week", "weekOfYear"})
    public static int week(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekOfWeekyear();
    }

    @ScalarFunction(names={"weekMV", "weekOfYearMV"})
    public static int[] weekMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.week(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfYear", "doy"})
    public static int dayOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfYear();
    }

    @ScalarFunction(names={"dayOfYearMV", "doyMV"})
    public static int[] dayOfYear(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfYear(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfYear", "doy"})
    public static int dayOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfYear();
    }

    @ScalarFunction(names={"dayOfYearMV", "doyMV"})
    public static int[] dayOfYear(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfYear(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfMonth", "day"})
    public static int dayOfMonth(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfMonth();
    }

    @ScalarFunction(names={"dayOfMonthMV", "dayMV"})
    public static int[] dayOfMonthMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfMonth(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfMonth", "day"})
    public static int dayOfMonth(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfMonth();
    }

    @ScalarFunction(names={"dayOfMonthMV", "dayMV"})
    public static int[] dayOfMonthMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfMonth(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfWeek", "dow"})
    public static int dayOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfWeek();
    }

    @ScalarFunction(names={"dayOfWeekMV", "dowMV"})
    public static int[] dayOfWeekMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfWeek(millis[i]);
        }
        return results;
    }

    @ScalarFunction(names={"dayOfWeek", "dow"})
    public static int dayOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfWeek();
    }

    @ScalarFunction(names={"dayOfWeekMV", "dowMV"})
    public static int[] dayOfWeekMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.dayOfWeek(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int hour(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getHourOfDay();
    }

    @ScalarFunction
    public static int[] hourMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.hour(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int hour(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getHourOfDay();
    }

    @ScalarFunction
    public static int[] hourMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.hour(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int minute(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMinuteOfHour();
    }

    @ScalarFunction
    public static int[] minuteMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.minute(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int minute(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMinuteOfHour();
    }

    @ScalarFunction
    public static int[] minuteMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.minute(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int second(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getSecondOfMinute();
    }

    @ScalarFunction
    public static int[] secondMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.second(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int second(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getSecondOfMinute();
    }

    @ScalarFunction
    public static int[] secondMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.second(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static int millisecond(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMillisOfSecond();
    }

    @ScalarFunction
    public static int[] millisecondMV(long[] millis) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.millisecond(millis[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int millisecond(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMillisOfSecond();
    }

    @ScalarFunction
    public static int[] millisecondMV(long[] millis, String timezoneId) {
        int[] results = new int[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            results[i] = DateTimeFunctions.millisecond(millis[i], timezoneId);
        }
        return results;
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, TimeUnit.MILLISECONDS.name(), ISOChronology.getInstanceUTC(), TimeUnit.MILLISECONDS.name());
    }

    @ScalarFunction
    public static long[] dateTruncMV(String unit, long[] timeValue) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i]);
        }
        return results;
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnit) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, ISOChronology.getInstanceUTC(), inputTimeUnit);
    }

    @ScalarFunction
    public static long[] dateTruncMV(String unit, long[] timeValue, String inputTimeUnit) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i], inputTimeUnit);
        }
        return results;
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnit, String timeZone) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, DateTimeUtils.getChronology(TimeZoneKey.getTimeZoneKey(timeZone)), inputTimeUnit);
    }

    @ScalarFunction
    public static long[] dateTruncMV(String unit, long[] timeValue, String inputTimeUnit, String timeZone) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i], inputTimeUnit, timeZone);
        }
        return results;
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnit, String timeZone, String outputTimeUnit) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, DateTimeUtils.getChronology(TimeZoneKey.getTimeZoneKey(timeZone)), outputTimeUnit);
    }

    @ScalarFunction
    public static long[] dateTruncMV(String unit, long[] timeValue, String inputTimeUnit, String timeZone, String outputTimeUnit) {
        long[] results = new long[timeValue.length];
        for (int i = 0; i < timeValue.length; ++i) {
            results[i] = DateTimeFunctions.dateTrunc(unit, timeValue[i], inputTimeUnit, timeZone, outputTimeUnit);
        }
        return results;
    }

    private static long dateTrunc(String unit, long timeValue, String inputTimeUnit, ISOChronology chronology, String outputTimeUnit) {
        return TimeUnit.valueOf(outputTimeUnit.toUpperCase()).convert(DateTimeUtils.getTimestampField(chronology, unit).roundFloor(TimeUnit.MILLISECONDS.convert(timeValue, TimeUnit.valueOf(inputTimeUnit.toUpperCase()))), TimeUnit.MILLISECONDS);
    }

    @ScalarFunction
    public static Timestamp dateBin(String binWidthStr, Timestamp sourceTimestamp, Timestamp originTimestamp) {
        long originMillis = originTimestamp.getTime();
        long sourceMillis = sourceTimestamp.getTime();
        long binnedMillis = DateTimeFunctions.dateBin(binWidthStr, sourceMillis, originMillis);
        return new Timestamp(binnedMillis);
    }

    public static long dateBin(String binWidthStr, long sourceMillisEpoch, long originMillisEpoch) {
        long binWidthMillis = TimeUtils.convertPeriodToMillis((String)binWidthStr);
        long offsetFromOrigin = sourceMillisEpoch - originMillisEpoch;
        long binCount = offsetFromOrigin / binWidthMillis;
        return originMillisEpoch + binWidthMillis * binCount;
    }

    @ScalarFunction(names={"timestampAdd", "dateAdd"})
    public static long timestampAdd(String unit, long interval, long timestamp) {
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        long millis = DateTimeUtils.getTimestampField(chronology, unit).add(timestamp, interval);
        return millis;
    }

    @ScalarFunction(names={"timestampAddMV", "dateAddMV"})
    public static long[] timestampAddMV(String unit, long interval, long[] timestamp) {
        long[] results = new long[timestamp.length];
        for (int i = 0; i < timestamp.length; ++i) {
            results[i] = DateTimeFunctions.timestampAdd(unit, interval, timestamp[i]);
        }
        return results;
    }

    @ScalarFunction(names={"timestampDiff", "dateDiff"})
    public static long timestampDiff(String unit, long timestamp1, long timestamp2) {
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        return DateTimeUtils.getTimestampField(chronology, unit).getDifferenceAsLong(timestamp2, timestamp1);
    }

    @ScalarFunction(names={"timestampDiffMV", "dateDiffMV"})
    public static long[] timestampDiffMV(String unit, long[] timestamp1, long timestamp2) {
        long[] results = new long[timestamp1.length];
        for (int i = 0; i < timestamp1.length; ++i) {
            results[i] = DateTimeFunctions.timestampDiff(unit, timestamp1[i], timestamp2);
        }
        return results;
    }

    @ScalarFunction(names={"timestampDiffMVReverse", "dateDiffMVReverse"})
    public static long[] timestampDiffMVReverse(String unit, long timestamp1, long[] timestamp2) {
        long[] results = new long[timestamp2.length];
        for (int i = 0; i < timestamp2.length; ++i) {
            results[i] = DateTimeFunctions.timestampDiff(unit, timestamp1, timestamp2[i]);
        }
        return results;
    }

    @ScalarFunction
    public static int extract(String interval, long timestamp) {
        return DateTimeUtils.extract(DateTimeUtils.ExtractFieldType.valueOf(interval), timestamp);
    }
}

