/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeConvert {
    private DateTimeFormatSpec _inputFormatSpec;
    private DateTimeFormatSpec _outputFormatSpec;
    private DateTimeGranularitySpec _granularitySpec;
    private DateTimeZone _bucketingTimeZone;
    private MutableDateTime _dateTime;
    private StringBuilder _buffer;

    @ScalarFunction
    public Object dateTimeConvert(String timeValueStr, String inputFormatStr, String outputFormatStr, String outputGranularityStr) {
        if (this._inputFormatSpec == null) {
            this.init(inputFormatStr, outputFormatStr, outputGranularityStr, null, false);
        }
        long timeValueMs = this._inputFormatSpec.fromFormatToMillis(timeValueStr);
        if (this._outputFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
            this.truncateDateTime(timeValueMs);
            return this.getFormattedDate();
        }
        long granularityMs = this._granularitySpec.granularityToMillis();
        long roundedTimeValueMs = timeValueMs / granularityMs * granularityMs;
        if (this._outputFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.EPOCH) {
            return this._outputFormatSpec.getColumnUnit().convert(roundedTimeValueMs, TimeUnit.MILLISECONDS) / (long)this._outputFormatSpec.getColumnSize();
        }
        return this._outputFormatSpec.fromMillisToFormat(roundedTimeValueMs);
    }

    @ScalarFunction
    public Object dateTimeConvert(String timeValueStr, String inputFormatStr, String outputFormatStr, String outputGranularityStr, String bucketingTimeZone) {
        if (this._inputFormatSpec == null) {
            this.init(inputFormatStr, outputFormatStr, outputGranularityStr, bucketingTimeZone, true);
        }
        long timeValueMs = this._inputFormatSpec.fromFormatToMillis(timeValueStr);
        this.truncateDateTime(timeValueMs);
        if (this._outputFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
            return this.getFormattedDate();
        }
        timeValueMs = this._dateTime.getMillis();
        return this._outputFormatSpec.getColumnUnit().convert(timeValueMs, TimeUnit.MILLISECONDS) / (long)this._outputFormatSpec.getColumnSize();
    }

    private void init(String inputFormatStr, String outputFormatStr, String outputGranularityStr, String bucketingTimeZone, boolean bucketTzRequired) {
        DateTimeZone timeZone;
        this._inputFormatSpec = new DateTimeFormatSpec(inputFormatStr);
        this._outputFormatSpec = new DateTimeFormatSpec(outputFormatStr);
        this._granularitySpec = new DateTimeGranularitySpec(outputGranularityStr);
        if (bucketTzRequired) {
            try {
                timeZone = this._bucketingTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(ZoneId.of(bucketingTimeZone)));
            }
            catch (DateTimeException dte) {
                throw new IllegalArgumentException("Error parsing bucketing time zone: " + dte.getMessage(), dte);
            }
        } else {
            timeZone = this._outputFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT ? this._outputFormatSpec.getDateTimeFormatter().getZone() : DateTimeZone.UTC;
        }
        this._dateTime = new MutableDateTime(0L, timeZone);
        this._buffer = new StringBuilder();
    }

    private String getFormattedDate() {
        this._buffer.setLength(0);
        DateTimeFormatter outputFormatter = this._outputFormatSpec.getDateTimeFormatter();
        outputFormatter.printTo(this._buffer, (ReadableInstant)this._dateTime);
        return this._buffer.toString();
    }

    private void truncateDateTime(long timeValueMs) {
        this._dateTime.setMillis(timeValueMs);
        int size = this._granularitySpec.getSize();
        switch (this._granularitySpec.getTimeUnit()) {
            case MILLISECONDS: {
                this._dateTime.setMillisOfSecond(this._dateTime.getMillisOfSecond() / size * size);
                break;
            }
            case SECONDS: {
                this._dateTime.setSecondOfMinute(this._dateTime.getSecondOfMinute() / size * size);
                this._dateTime.secondOfMinute().roundFloor();
                break;
            }
            case MINUTES: {
                this._dateTime.setMinuteOfHour(this._dateTime.getMinuteOfHour() / size * size);
                this._dateTime.minuteOfHour().roundFloor();
                break;
            }
            case HOURS: {
                this._dateTime.setHourOfDay(this._dateTime.getHourOfDay() / size * size);
                this._dateTime.hourOfDay().roundFloor();
                break;
            }
            case DAYS: {
                this._dateTime.setDayOfMonth((this._dateTime.getDayOfMonth() - 1) / size * size + 1);
                this._dateTime.dayOfMonth().roundFloor();
                break;
            }
        }
    }
}

