/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class ArrayFunctions {
    private ArrayFunctions() {
    }

    @ScalarFunction
    public static int[] arrayReverseInt(int[] values) {
        int[] clone = (int[])values.clone();
        ArrayUtils.reverse((int[])clone);
        return clone;
    }

    @ScalarFunction
    public static String[] arrayReverseString(String[] values) {
        Object[] clone = (String[])values.clone();
        ArrayUtils.reverse((Object[])clone);
        return clone;
    }

    @ScalarFunction
    public static int[] arraySortInt(int[] values) {
        int[] clone = (int[])values.clone();
        Arrays.sort(clone);
        return clone;
    }

    @ScalarFunction
    public static String[] arraySortString(String[] values) {
        Object[] clone = (String[])values.clone();
        Arrays.sort(clone);
        return clone;
    }

    @ScalarFunction
    public static int arrayIndexOfInt(int[] values, int valueToFind) {
        return ArrayUtils.indexOf((int[])values, (int)valueToFind);
    }

    @ScalarFunction
    public static int arrayIndexOfString(String[] values, String valueToFind) {
        return ArrayUtils.indexOf((Object[])values, (Object)valueToFind);
    }

    @ScalarFunction
    public static int[] arrayIndexesOfInt(int[] value, int valueToFind) {
        return ArrayUtils.indexesOf((int[])value, (int)valueToFind).stream().toArray();
    }

    @ScalarFunction
    public static int[] arrayIndexesOfLong(long[] value, long valueToFind) {
        return ArrayUtils.indexesOf((long[])value, (long)valueToFind).stream().toArray();
    }

    @ScalarFunction
    public static int[] arrayIndexesOfFloat(float[] value, float valueToFind) {
        return ArrayUtils.indexesOf((float[])value, (float)valueToFind).stream().toArray();
    }

    @ScalarFunction
    public static int[] arrayIndexesOfDouble(double[] value, double valueToFind) {
        return ArrayUtils.indexesOf((double[])value, (double)valueToFind).stream().toArray();
    }

    @ScalarFunction
    public static int[] arrayIndexesOfString(String[] value, String valueToFind) {
        return ArrayUtils.indexesOf((Object[])value, (Object)valueToFind).stream().toArray();
    }

    @ScalarFunction
    public static int[] intersectIndices(int[] values1, int[] values2) {
        int j = 0;
        IntArrayList indices = new IntArrayList();
        for (int i = 0; i < values1.length && j < values2.length; ++i) {
            if (values1[i] != values2[j]) continue;
            indices.add(values1[i]);
            ++j;
        }
        return indices.toIntArray();
    }

    @ScalarFunction
    public static boolean arrayContainsInt(int[] values, int valueToFind) {
        return ArrayUtils.contains((int[])values, (int)valueToFind);
    }

    @ScalarFunction
    public static boolean arrayContainsString(String[] values, String valueToFind) {
        return ArrayUtils.contains((Object[])values, (Object)valueToFind);
    }

    @ScalarFunction
    public static int[] arraySliceInt(int[] values, int start, int end) {
        return Arrays.copyOfRange(values, start, end);
    }

    @ScalarFunction
    public static String[] arraySliceString(String[] values, int start, int end) {
        return Arrays.copyOfRange(values, start, end);
    }

    @ScalarFunction
    public static int[] arrayDistinctInt(int[] values) {
        return new IntLinkedOpenHashSet(values).toIntArray();
    }

    @ScalarFunction
    public static String[] arrayDistinctString(String[] values) {
        return (String[])new ObjectLinkedOpenHashSet((Object[])values).toArray((Object[])new String[0]);
    }

    @ScalarFunction
    public static int[] arrayRemoveInt(int[] values, int element) {
        return ArrayUtils.removeElement((int[])values, (int)element);
    }

    @ScalarFunction
    public static String[] arrayRemoveString(String[] values, String element) {
        return (String[])ArrayUtils.removeElement((Object[])values, (Object)element);
    }

    @ScalarFunction
    public static int[] arrayUnionInt(int[] values1, int[] values2) {
        IntLinkedOpenHashSet set = new IntLinkedOpenHashSet(values1);
        set.addAll((IntCollection)IntArrayList.wrap((int[])values2));
        return set.toIntArray();
    }

    @ScalarFunction
    public static String[] arrayUnionString(String[] values1, String[] values2) {
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet((Object[])values1);
        set.addAll(Arrays.asList(values2));
        return (String[])set.toArray((Object[])new String[0]);
    }

    @ScalarFunction
    public static int[] arrayConcatInt(int[] values1, int[] values2) {
        return ArrayUtils.addAll((int[])values1, (int[])values2);
    }

    @ScalarFunction
    public static long[] arrayConcatLong(long[] values1, long[] values2) {
        return ArrayUtils.addAll((long[])values1, (long[])values2);
    }

    @ScalarFunction
    public static float[] arrayConcatFloat(float[] values1, float[] values2) {
        return ArrayUtils.addAll((float[])values1, (float[])values2);
    }

    @ScalarFunction
    public static double[] arrayConcatDouble(double[] values1, double[] values2) {
        return ArrayUtils.addAll((double[])values1, (double[])values2);
    }

    @ScalarFunction
    public static String[] arrayConcatString(String[] values1, String[] values2) {
        return (String[])ArrayUtils.addAll((Object[])values1, (Object[])values2);
    }

    @ScalarFunction
    public static int arrayElementAtInt(int[] arr, int idx) {
        return idx > 0 && idx <= arr.length ? arr[idx - 1] : 0;
    }

    @ScalarFunction
    public static long arrayElementAtLong(long[] arr, int idx) {
        return idx > 0 && idx <= arr.length ? arr[idx - 1] : 0L;
    }

    @ScalarFunction
    public static float arrayElementAtFloat(float[] arr, int idx) {
        return idx > 0 && idx <= arr.length ? arr[idx - 1] : 0.0f;
    }

    @ScalarFunction
    public static double arrayElementAtDouble(double[] arr, int idx) {
        return idx > 0 && idx <= arr.length ? arr[idx - 1] : 0.0;
    }

    @ScalarFunction
    public static String arrayElementAtString(String[] arr, int idx) {
        return idx > 0 && idx <= arr.length ? arr[idx - 1] : "";
    }

    @ScalarFunction
    public static int arraySumInt(int[] arr) {
        int sum = 0;
        for (int value : arr) {
            sum += value;
        }
        return sum;
    }

    @ScalarFunction
    public static long arraySumLong(long[] arr) {
        long sum = 0L;
        for (long value : arr) {
            sum += value;
        }
        return sum;
    }

    @ScalarFunction(names={"array", "arrayValueConstructor"}, isVarArg=true)
    public static Object arrayValueConstructor(Object ... arr) {
        if (arr == null || arr.length == 0) {
            return arr;
        }
        Class<?> clazz = arr[0].getClass();
        if (clazz == Integer.class) {
            int[] intArr = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                intArr[i] = (Integer)arr[i];
            }
            return intArr;
        }
        if (clazz == Long.class) {
            long[] longArr = new long[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                longArr[i] = (Long)arr[i];
            }
            return longArr;
        }
        if (clazz == Float.class) {
            float[] floatArr = new float[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                floatArr[i] = ((Float)arr[i]).floatValue();
            }
            return floatArr;
        }
        if (clazz == Double.class) {
            double[] doubleArr = new double[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                doubleArr[i] = (Double)arr[i];
            }
            return doubleArr;
        }
        if (clazz == Boolean.class) {
            boolean[] boolArr = new boolean[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                boolArr[i] = (Boolean)arr[i];
            }
            return boolArr;
        }
        if (clazz == BigDecimal.class) {
            BigDecimal[] bigDecimalArr = new BigDecimal[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                bigDecimalArr[i] = (BigDecimal)arr[i];
            }
            return bigDecimalArr;
        }
        if (clazz == String.class) {
            String[] strArr = new String[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                strArr[i] = (String)arr[i];
            }
            return strArr;
        }
        return arr;
    }

    @ScalarFunction
    public static int[] generateIntArray(int start, int end, int inc) {
        int size = (end - start) / inc + 1;
        int[] arr = new int[size];
        int i = 0;
        int value = start;
        while (i < size) {
            arr[i] = value;
            ++i;
            value += inc;
        }
        return arr;
    }

    @ScalarFunction
    public static long[] generateLongArray(long start, long end, long inc) {
        int size = (int)((end - start) / inc + 1L);
        long[] arr = new long[size];
        int i = 0;
        while (i < size) {
            arr[i] = start;
            ++i;
            start += inc;
        }
        return arr;
    }

    @ScalarFunction
    public static float[] generateFloatArray(float start, float end, float inc) {
        int size = (int)((end - start) / inc + 1.0f);
        float[] arr = new float[size];
        int i = 0;
        while (i < size) {
            arr[i] = start;
            ++i;
            start += inc;
        }
        return arr;
    }

    @ScalarFunction
    public static double[] generateDoubleArray(double start, double end, double inc) {
        int size = (int)((end - start) / inc + 1.0);
        double[] arr = new double[size];
        int i = 0;
        while (i < size) {
            arr[i] = start;
            ++i;
            start += inc;
        }
        return arr;
    }

    @ScalarFunction
    public static String arrayToString(String[] values, String delimiter) {
        return String.join((CharSequence)delimiter, values);
    }

    @ScalarFunction
    public static String arrayToString(String[] values, String delimiter, String nullString) {
        if (values == null || values.length == 0) {
            return "";
        }
        return String.join((CharSequence)delimiter, (CharSequence[])Arrays.stream(values).map(s -> s == null || s.equals("") ? nullString : s).toArray(String[]::new));
    }
}

