/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;

public enum TransformFunctionType {
    ADD("add", "plus"),
    SUB("sub", "minus"),
    MULT("mult", "times"),
    DIV("div", "divide"),
    MOD("mod", new String[0]),
    ABS("abs", new String[0]),
    CEIL("ceil", "ceiling"),
    EXP("exp", new String[0]),
    FLOOR("floor", new String[0]),
    LOG("log", "ln"),
    LOG2("log2", new String[0]),
    LOG10("log10", new String[0]),
    SIGN("sign", new String[0]),
    ROUND_DECIMAL("roundDecimal", new String[0]),
    TRUNCATE("truncate", new String[0]),
    POWER("power", "pow"),
    SQRT("sqrt", new String[0]),
    LEAST("least", new String[0]),
    GREATEST("greatest", new String[0]),
    EQUALS("equals", new String[0]),
    NOT_EQUALS("not_equals", new String[0]),
    GREATER_THAN("greater_than", new String[0]),
    GREATER_THAN_OR_EQUAL("greater_than_or_equal", new String[0]),
    LESS_THAN("less_than", new String[0]),
    LESS_THAN_OR_EQUAL("less_than_or_equal", new String[0]),
    IN("in", new String[0]),
    NOT_IN("not_in", new String[0]),
    IS_TRUE("is_true", new String[0]),
    IS_NOT_TRUE("is_not_true", new String[0]),
    IS_FALSE("is_false", new String[0]),
    IS_NOT_FALSE("is_not_false", new String[0]),
    IS_NULL("is_null", new String[0]),
    IS_NOT_NULL("is_not_null", new String[0]),
    IS_DISTINCT_FROM("is_distinct_from", new String[0]),
    IS_NOT_DISTINCT_FROM("is_not_distinct_from", new String[0]),
    COALESCE("coalesce", new String[0]),
    AND("and", new String[0]),
    OR("or", new String[0]),
    NOT("not", new String[0]),
    CASE("case", new String[0]),
    CAST("cast", new String[0]),
    JSON_EXTRACT_SCALAR("jsonExtractScalar", opBinding -> TransformFunctionType.positionalReturnTypeInferenceFromStringLiteral(opBinding, 2, SqlTypeName.VARCHAR), (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER), i -> i == 3), new String[0]),
    JSON_EXTRACT_INDEX("jsonExtractIndex", opBinding -> TransformFunctionType.positionalReturnTypeInferenceFromStringLiteral(opBinding, 2, SqlTypeName.VARCHAR), (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER), i -> i > 2), new String[0]),
    JSON_EXTRACT_KEY("jsonExtractKey", ReturnTypes.TO_ARRAY, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER)), new String[0]),
    TIME_CONVERT("timeConvert", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER)), new String[0]),
    DATE_TIME_CONVERT("dateTimeConvert", TransformFunctionType::dateTimeConverterReturnTypeInference, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER), i -> i == 4), new String[0]),
    DATE_TIME_CONVERT_WINDOW_HOP("dateTimeConvertWindowHop", (SqlReturnTypeInference)ReturnTypes.cascade(TransformFunctionType::dateTimeConverterReturnTypeInference, (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_ARRAY}), (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER)), new String[0]),
    DATE_TRUNC("dateTrunc", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER), i -> i > 1), new String[0]),
    YEAR("year", new String[0]),
    YEAR_OF_WEEK("yearOfWeek", "yow"),
    QUARTER("quarter", new String[0]),
    MONTH_OF_YEAR("monthOfYear", "month"),
    WEEK_OF_YEAR("weekOfYear", "week"),
    DAY_OF_YEAR("dayOfYear", "doy"),
    DAY_OF_MONTH("dayOfMonth", "day"),
    DAY_OF_WEEK("dayOfWeek", "dow"),
    HOUR("hour", new String[0]),
    MINUTE("minute", new String[0]),
    SECOND("second", new String[0]),
    MILLISECOND("millisecond", new String[0]),
    EXTRACT("extract", new String[0]),
    ARRAY_LENGTH("arrayLength", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.ARRAY, "cardinality"),
    ARRAY_AVERAGE("arrayAverage", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    ARRAY_MIN("arrayMin", TransformFunctionType::componentType, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    ARRAY_MAX("arrayMax", TransformFunctionType::componentType, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    ARRAY_SUM("arraySum", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    ARRAY_SUM_INT("arraySumInt", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    ARRAY_SUM_LONG("arraySumLong", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    VALUE_IN("valueIn", ReturnTypes.ARG0, OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)2)), new String[0]),
    MAP_VALUE("mapValue", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> TransformFunctionType.positionalComponentType(opBinding, 2), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.ANY, SqlTypeFamily.ARRAY)), new String[0]),
    IN_ID_SET("inIdSet", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER}), new String[0]),
    LOOKUP("lookUp", new String[0]),
    GROOVY("groovy", new String[0]),
    SCALAR("scalar", new String[0]),
    CLP_DECODE("clpDecode", ReturnTypes.VARCHAR_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY, SqlTypeFamily.CHARACTER), i -> i == 3), new String[0]),
    CLP_ENCODED_VARS_MATCH("clpEncodedVarsMatch", ReturnTypes.BOOLEAN_NOT_NULL, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.ARRAY, SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER}), new String[0]),
    REGEXP_EXTRACT("regexpExtract", ReturnTypes.VARCHAR_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.CHARACTER), i -> i > 1), new String[0]),
    ST_GEOG_FROM_TEXT("ST_GeogFromText", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.CHARACTER, new String[0]),
    ST_GEOM_FROM_TEXT("ST_GeomFromText", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.CHARACTER, new String[0]),
    ST_GEOG_FROM_GEO_JSON("ST_GeogFromGeoJSON", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.CHARACTER, new String[0]),
    ST_GEOM_FROM_GEO_JSON("ST_GeomFromGeoJSON", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.CHARACTER, new String[0]),
    ST_GEOG_FROM_WKB("ST_GeogFromWKB", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_GEOM_FROM_WKB("ST_GeomFromWKB", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_POINT("ST_Point", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.ANY), i -> i == 2), new String[0]),
    ST_POLYGON("ST_Polygon", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.CHARACTER, new String[0]),
    ST_AREA("ST_Area", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_DISTANCE("ST_Distance", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.BINARY_BINARY, new String[0]),
    ST_GEOMETRY_TYPE("ST_GeometryType", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_AS_BINARY("ST_AsBinary", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_AS_TEXT("ST_AsText", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_AS_GEO_JSON("ST_AsGeoJSON", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_CONTAINS("ST_Contains", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.BINARY_BINARY, new String[0]),
    ST_EQUALS("ST_Equals", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.BINARY_BINARY, new String[0]),
    ST_WITHIN("ST_Within", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.BINARY_BINARY, new String[0]),
    GEO_TO_H3("geoToH3", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER})}), new String[0]),
    COSINE_DISTANCE("cosineDistance", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC), id -> id == 2), new String[0]),
    INNER_PRODUCT("innerProduct", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY_ARRAY, new String[0]),
    L1_DISTANCE("l1Distance", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY_ARRAY, new String[0]),
    L2_DISTANCE("l2Distance", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY_ARRAY, new String[0]),
    VECTOR_DIMS("vectorDims", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    VECTOR_NORM("vectorNorm", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY, new String[0]),
    SIN("sin", new String[0]),
    COS("cos", new String[0]),
    TAN("tan", new String[0]),
    COT("cot", new String[0]),
    ASIN("asin", new String[0]),
    ACOS("acos", new String[0]),
    ATAN("atan", new String[0]),
    ATAN2("atan2", new String[0]),
    SINH("sinh", new String[0]),
    COSH("cosh", new String[0]),
    TANH("tanh", new String[0]),
    DEGREES("degrees", new String[0]),
    RADIANS("radians", new String[0]),
    ITEM("item", new String[0]);

    private final String _name;
    private final List<String> _names;
    private final SqlReturnTypeInference _returnTypeInference;
    private final SqlOperandTypeChecker _operandTypeChecker;

    private TransformFunctionType(String name, String ... alternativeNames) {
        this(name, (SqlReturnTypeInference)null, (SqlOperandTypeChecker)null, alternativeNames);
    }

    private TransformFunctionType(@Nullable String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, String ... alternativeNames) {
        this._name = name;
        int numAlternativeNames = alternativeNames.length;
        if (numAlternativeNames == 0) {
            this._names = List.of(name);
        } else {
            ArrayList<String> names = new ArrayList<String>(numAlternativeNames + 1);
            names.add(name);
            names.addAll(Arrays.asList(alternativeNames));
            this._names = List.copyOf(names);
        }
        this._returnTypeInference = returnTypeInference;
        this._operandTypeChecker = operandTypeChecker;
    }

    public String getName() {
        return this._name;
    }

    public List<String> getNames() {
        return this._names;
    }

    @Deprecated
    public List<String> getAlternativeNames() {
        return this._names;
    }

    public SqlReturnTypeInference getReturnTypeInference() {
        return this._returnTypeInference;
    }

    public SqlOperandTypeChecker getOperandTypeChecker() {
        return this._operandTypeChecker;
    }

    private static RelDataType positionalReturnTypeInferenceFromStringLiteral(SqlOperatorBinding opBinding, int pos) {
        return TransformFunctionType.positionalReturnTypeInferenceFromStringLiteral(opBinding, pos, SqlTypeName.ANY);
    }

    private static RelDataType positionalReturnTypeInferenceFromStringLiteral(SqlOperatorBinding opBinding, int pos, SqlTypeName defaultSqlType) {
        if (opBinding.getOperandCount() > pos && opBinding.isOperandLiteral(pos, false)) {
            String operandType = ((String)opBinding.getOperandLiteralValue(pos, String.class)).toUpperCase();
            return TransformFunctionType.inferTypeFromStringLiteral(operandType, opBinding.getTypeFactory());
        }
        return opBinding.getTypeFactory().createSqlType(defaultSqlType);
    }

    private static RelDataType componentType(SqlOperatorBinding opBinding) {
        return opBinding.getOperandType(0).getComponentType();
    }

    private static RelDataType positionalComponentType(SqlOperatorBinding opBinding, int pos) {
        return opBinding.getOperandType(pos).getComponentType();
    }

    private static RelDataType dateTimeConverterReturnTypeInference(SqlOperatorBinding opBinding) {
        String outputFormatStr;
        DateTimeFormatSpec dateTimeFormatSpec;
        int outputFormatPos = 2;
        if (opBinding.getOperandCount() > outputFormatPos && opBinding.isOperandLiteral(outputFormatPos, false) && ((dateTimeFormatSpec = new DateTimeFormatSpec(outputFormatStr = (String)opBinding.getOperandLiteralValue(outputFormatPos, String.class))).getTimeFormat() == DateTimeFieldSpec.TimeFormat.EPOCH || dateTimeFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.TIMESTAMP)) {
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        }
        return opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
    }

    private static RelDataType inferTypeFromStringLiteral(String operandTypeStr, RelDataTypeFactory typeFactory) {
        switch (operandTypeStr) {
            case "INT": {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case "INT_ARRAY": {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.INTEGER), -1L);
            }
            case "LONG": {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case "LONG_ARRAY": {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.BIGINT), -1L);
            }
            case "FLOAT": {
                return typeFactory.createSqlType(SqlTypeName.REAL);
            }
            case "FLOAT_ARRAY": {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.REAL), -1L);
            }
            case "DOUBLE_ARRAY": {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.DOUBLE), -1L);
            }
            case "STRING": {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
            case "STRING_ARRAY": {
                return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.VARCHAR), -1L);
            }
            case "BYTES": {
                return typeFactory.createSqlType(SqlTypeName.VARBINARY);
            }
            case "BIG_DECIMAL": {
                return typeFactory.createSqlType(SqlTypeName.DECIMAL);
            }
        }
        SqlTypeName sqlTypeName = SqlTypeName.get((String)operandTypeStr);
        if (sqlTypeName == null) {
            throw new IllegalArgumentException("Invalid type: " + operandTypeStr);
        }
        return typeFactory.createSqlType(sqlTypeName);
    }
}

