/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.cache.Cache;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public class JsonPathCache
implements Cache {
    public static final JsonPathCache INSTANCE = new JsonPathCache();
    private static final long DEFAULT_CACHE_MAXIMUM_SIZE = 10000L;
    private static final Predicate[] NO_PREDICATES = new Predicate[0];
    private final LoadingCache<String, JsonPath> _jsonPathCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, JsonPath>(){

        public JsonPath load(@Nonnull String jsonPath) {
            return JsonPath.compile((String)jsonPath, (Predicate[])NO_PREDICATES);
        }
    });

    public JsonPath get(String key) {
        return (JsonPath)this._jsonPathCache.getIfPresent((Object)key);
    }

    public JsonPath getOrCompute(String key) {
        try {
            return (JsonPath)this._jsonPathCache.get((Object)key);
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public void put(String key, JsonPath value) {
        this._jsonPathCache.put((Object)key, (Object)value);
    }

    @VisibleForTesting
    public long size() {
        return this._jsonPathCache.size();
    }
}

