/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datatable;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableImplV4;

public class DataTableFactory {
    public static final int VERSION_4 = 4;

    private DataTableFactory() {
    }

    public static DataTable getDataTable(ByteBuffer byteBuffer) throws IOException {
        int version = byteBuffer.getInt();
        Preconditions.checkState((version == 4 ? 1 : 0) != 0, (String)"Unsupported data table version: %s", (int)version);
        return new DataTableImplV4(byteBuffer);
    }

    public static DataTable getDataTable(byte[] bytes) throws IOException {
        return DataTableFactory.getDataTable(ByteBuffer.wrap(bytes));
    }
}

