/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import javax.annotation.Nonnull;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.segment.spi.memory.DataBuffer;

public class RowDataBlock
extends BaseDataBlock {
    private static final int VERSION = 2;
    protected int[] _columnOffsets;
    protected int _rowSizeInBytes;
    private int _fixDataSize;

    public RowDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    public RowDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, DataBuffer fixedSizeDataBytes, DataBuffer variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    protected void computeBlockObjectConstants() {
        if (this._dataSchema != null) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
            this._fixDataSize = this._numRows * this._rowSizeInBytes;
        }
    }

    @Override
    protected int getFixDataSize() {
        return this._fixDataSize;
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return rowId * this._rowSizeInBytes + this._columnOffsets[colId];
    }

    public int getRowSizeInBytes() {
        return this._rowSizeInBytes;
    }

    @Override
    public DataBlock.Type getDataBlockType() {
        return DataBlock.Type.ROW;
    }

    @Override
    @Nonnull
    public DataSchema getDataSchema() {
        return super.getDataSchema();
    }
}

