/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockSerde;
import org.apache.pinot.common.datablock.MetadataBlock;
import org.apache.pinot.common.datablock.ZeroCopyDataBlockSerde;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.segment.spi.memory.CompoundDataBuffer;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;

public final class DataBlockUtils {
    private static final EnumMap<DataBlockSerde.Version, DataBlockSerde> SERDES = new EnumMap(DataBlockSerde.Version.class);
    static final int VERSION_TYPE_SHIFT = 5;

    @VisibleForTesting
    public static DataBlockSerde getSerde(DataBlockSerde.Version version) {
        return SERDES.get((Object)version);
    }

    @VisibleForTesting
    public static void setSerde(DataBlockSerde.Version version, DataBlockSerde serde) {
        SERDES.put(version, serde);
    }

    private DataBlockUtils() {
    }

    public static MetadataBlock getErrorDataBlock(Exception e) {
        if (e instanceof ProcessingException) {
            return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(((ProcessingException)((Object)e)).getErrorCode(), DataBlockUtils.extractErrorMsg(e)));
        }
        return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(1000, DataBlockUtils.extractErrorMsg(e)));
    }

    private static String extractErrorMsg(Throwable t) {
        while (t.getCause() != null && t.getMessage() == null) {
            t = t.getCause();
        }
        return t.getMessage() + "\n" + QueryException.getTruncatedStackTrace(t);
    }

    public static MetadataBlock getErrorDataBlock(Map<Integer, String> exceptions) {
        return MetadataBlock.newError(exceptions);
    }

    public static int readVersionType(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }

    public static int getVersion(int versionType) {
        return versionType & 0x1F;
    }

    public static DataBlock.Type getType(int versionType) {
        return DataBlock.Type.fromOrdinal(versionType >> 5);
    }

    public static List<ByteBuffer> serialize(DataBlock dataBlock) throws IOException {
        return DataBlockUtils.serialize(DataBlockSerde.Version.V1_V2, dataBlock);
    }

    @VisibleForTesting
    public static List<ByteBuffer> serialize(DataBlockSerde.Version version, DataBlock dataBlock) throws IOException {
        DataBlockSerde dataBlockSerde = SERDES.get((Object)version);
        if (dataBlockSerde == null) {
            throw new UnsupportedOperationException("Unsupported data block version: " + version);
        }
        DataBlock.Type dataBlockType = dataBlock.getDataBlockType();
        int firstInt = version.getVersion() + (dataBlockType.ordinal() << 5);
        DataBuffer dataBuffer = dataBlockSerde.serialize(dataBlock, firstInt);
        int readFirstByte = dataBuffer.order() != ByteOrder.BIG_ENDIAN ? dataBuffer.view(0L, 4L, ByteOrder.BIG_ENDIAN).getInt(0) : dataBuffer.getInt(0);
        Preconditions.checkState((readFirstByte == firstInt ? 1 : 0) != 0, (String)"Illegal serialization by {}. The first integer should be {} but is {} instead", (Object)dataBuffer.getClass().getName(), (Object)firstInt, (Object)readFirstByte);
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        dataBuffer.appendAsByteBuffers(result);
        return result;
    }

    public static ByteString toByteString(DataBlock dataBlock) throws IOException {
        ByteString byteString;
        List<ByteBuffer> bytes = dataBlock.serialize();
        if (bytes.isEmpty()) {
            byteString = ByteString.EMPTY;
        } else {
            byteString = UnsafeByteOperations.unsafeWrap((ByteBuffer)bytes.get(0));
            for (int i = 1; i < bytes.size(); ++i) {
                byteString = byteString.concat(UnsafeByteOperations.unsafeWrap((ByteBuffer)bytes.get(i)));
            }
        }
        return byteString;
    }

    public static DataBlock readFrom(ByteBuffer buffer) throws IOException {
        return DataBlockUtils.deserialize((DataBuffer)PinotByteBuffer.wrap((ByteBuffer)buffer), buffer.position(), newOffset -> {
            if (newOffset > Integer.MAX_VALUE) {
                throw new IllegalStateException("Data block is too large");
            }
            buffer.position((int)newOffset);
        });
    }

    public static DataBlock deserialize(List<ByteBuffer> buffers) throws IOException {
        List dataBuffers = buffers.stream().map(PinotByteBuffer::wrap).collect(Collectors.toList());
        try (CompoundDataBuffer compoundBuffer = new CompoundDataBuffer(dataBuffers, ByteOrder.BIG_ENDIAN, false);){
            DataBlock dataBlock = DataBlockUtils.deserialize((DataBuffer)compoundBuffer);
            return dataBlock;
        }
    }

    public static DataBlock deserialize(ByteBuffer[] buffers) throws IOException {
        try (CompoundDataBuffer compoundBuffer = new CompoundDataBuffer(buffers, ByteOrder.BIG_ENDIAN, false);){
            DataBlock dataBlock = DataBlockUtils.deserialize((DataBuffer)compoundBuffer);
            return dataBlock;
        }
    }

    public static DataBlock deserialize(DataBuffer buffer) throws IOException {
        return DataBlockUtils.deserialize(buffer, 0L, null);
    }

    public static DataBlock deserialize(DataBuffer buffer, long offset, @Nullable LongConsumer finalOffsetConsumer) throws IOException {
        DataBlock.Type type;
        DataBlockSerde dataBlockSerde;
        int versionAndSubVersion = buffer.getInt(offset);
        int version = DataBlockUtils.getVersion(versionAndSubVersion);
        try {
            dataBlockSerde = SERDES.get((Object)DataBlockSerde.Version.fromInt(version));
        }
        catch (Exception e) {
            throw new IOException("Failed to get serde for version: " + version, e);
        }
        try {
            type = DataBlockUtils.getType(versionAndSubVersion);
        }
        catch (Exception e) {
            throw new IOException("Failed to get type for version: " + version, e);
        }
        try {
            return dataBlockSerde.deserialize(buffer, 0L, type, finalOffsetConsumer);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize data block with serde " + dataBlockSerde.getClass(), e);
        }
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static void computeColumnSizeInBytes(DataSchema dataSchema, int[] columnSizes) {
        int numColumns = columnSizes.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        block7: for (int i = 0; i < numColumns; ++i) {
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case LONG: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case FLOAT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case DOUBLE: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case STRING: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                default: {
                    columnSizes[i] = 8;
                }
            }
        }
    }

    static {
        SERDES.put(DataBlockSerde.Version.V1_V2, new ZeroCopyDataBlockSerde());
    }
}

