/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.pinot.common.CustomObject;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.datatable.DataTableUtils;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.apache.pinot.segment.spi.memory.PinotInputStream;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.MapUtils;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseDataBlock
implements DataBlock {
    protected static final int HEADER_SIZE = 52;
    protected Map<Integer, String> _errCodeToExceptionMap;
    protected final int _numRows;
    protected final int _numColumns;
    @Nullable
    protected final DataSchema _dataSchema;
    protected final String[] _stringDictionary;
    protected final DataBuffer _fixedSizeData;
    protected final DataBuffer _variableSizeData;
    @Nullable
    private List<ByteBuffer> _serialized;

    public BaseDataBlock(int numRows, @Nullable DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        this._numRows = numRows;
        this._dataSchema = dataSchema;
        this._numColumns = dataSchema == null ? 0 : dataSchema.size();
        this._stringDictionary = stringDictionary;
        this._fixedSizeData = PinotByteBuffer.wrap((byte[])fixedSizeDataBytes);
        this._variableSizeData = PinotByteBuffer.wrap((byte[])variableSizeDataBytes);
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public BaseDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, DataBuffer fixedSizeData, DataBuffer variableSizeData) {
        Preconditions.checkArgument((fixedSizeData.size() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Fixed size data too large ({} bytes", (long)fixedSizeData.size());
        Preconditions.checkArgument((variableSizeData.size() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Variable size data too large ({} bytes", (long)variableSizeData.size());
        this._numRows = numRows;
        this._dataSchema = dataSchema;
        this._numColumns = dataSchema.size();
        this._stringDictionary = stringDictionary;
        this._fixedSizeData = fixedSizeData;
        this._variableSizeData = variableSizeData;
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    protected abstract int getOffsetInFixedBuffer(int var1, int var2);

    @Override
    public Map<String, String> getMetadata() {
        return Collections.emptyMap();
    }

    @Override
    @Nullable
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Override
    public int getNumberOfRows() {
        return this._numRows;
    }

    @Override
    public int getNumberOfColumns() {
        return this._numColumns;
    }

    @Override
    public int getInt(int rowId, int colId) {
        return this._fixedSizeData.getInt(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public long getLong(int rowId, int colId) {
        return this._fixedSizeData.getLong(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public float getFloat(int rowId, int colId) {
        return this._fixedSizeData.getFloat(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public double getDouble(int rowId, int colId) {
        return this._fixedSizeData.getDouble(this.getOffsetInFixedBuffer(rowId, colId));
    }

    @Override
    public BigDecimal getBigDecimal(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        byte[] buffer = new byte[size];
        this._variableSizeData.copyTo((long)offsetInVar, buffer, 0, size);
        return BigDecimalUtils.deserialize((byte[])buffer);
    }

    @Override
    public String getString(int rowId, int colId) {
        return this._stringDictionary[this._fixedSizeData.getInt(this.getOffsetInFixedBuffer(rowId, colId))];
    }

    @Override
    public ByteArray getBytes(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        byte[] buffer = new byte[size];
        this._variableSizeData.copyTo((long)offsetInVar, buffer, 0, size);
        return new ByteArray(buffer);
    }

    @Override
    public int[] getIntArray(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        int[] ints = new int[size];
        try (PinotInputStream stream = this._variableSizeData.openInputStream((long)offsetInVar);){
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = stream.readInt();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ints;
    }

    @Override
    public long[] getLongArray(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        long[] longs = new long[size];
        try (PinotInputStream stream = this._variableSizeData.openInputStream((long)offsetInVar);){
            for (int i = 0; i < longs.length; ++i) {
                longs[i] = stream.readLong();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return longs;
    }

    @Override
    public float[] getFloatArray(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        float[] floats = new float[size];
        try (PinotInputStream stream = this._variableSizeData.openInputStream((long)offsetInVar);){
            for (int i = 0; i < floats.length; ++i) {
                floats[i] = stream.readFloat();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return floats;
    }

    @Override
    public double[] getDoubleArray(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        double[] doubles = new double[size];
        try (PinotInputStream stream = this._variableSizeData.openInputStream((long)offsetInVar);){
            for (int i = 0; i < doubles.length; ++i) {
                doubles[i] = stream.readDouble();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return doubles;
    }

    @Override
    public String[] getStringArray(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        String[] strings = new String[size];
        try (PinotInputStream stream = this._variableSizeData.openInputStream((long)offsetInVar);){
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = this._stringDictionary[stream.readInt()];
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return strings;
    }

    @Override
    public Map<String, Object> getMap(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        byte[] buffer = new byte[size];
        this._variableSizeData.copyTo((long)offsetInVar, buffer, 0, size);
        return MapUtils.deserializeMap((byte[])buffer);
    }

    @Override
    @Nullable
    public CustomObject getCustomObject(int rowId, int colId) {
        int offsetInFixed = this.getOffsetInFixedBuffer(rowId, colId);
        int size = this._fixedSizeData.getInt(offsetInFixed + 4);
        int offsetInVar = this._fixedSizeData.getInt(offsetInFixed);
        int type = this._variableSizeData.getInt(offsetInVar);
        if (size == 0) {
            assert (type == 100);
            return null;
        }
        return new CustomObject(type, this._variableSizeData.copyOrView((long)(offsetInVar + 4), size));
    }

    protected abstract int getFixDataSize();

    @Override
    @Nullable
    public RoaringBitmap getNullRowIds(int colId) {
        int position = this.getFixDataSize() + colId * 4 * 2;
        if (this._fixedSizeData == null || (long)position >= this._fixedSizeData.size()) {
            return null;
        }
        int offset = this._fixedSizeData.getInt(position);
        int bytesLength = this._fixedSizeData.getInt(position + 4);
        if (bytesLength > 0) {
            return this._variableSizeData.viewAsRoaringBitmap((long)offset, bytesLength).toRoaringBitmap();
        }
        return null;
    }

    protected byte[] serializeStringDictionary() throws IOException {
        if (this._stringDictionary.length == 0) {
            return new byte[4];
        }
        UnsynchronizedByteArrayOutputStream byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        dataOutputStream.writeInt(this._stringDictionary.length);
        for (String entry : this._stringDictionary) {
            byte[] valueBytes = entry.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected String[] deserializeStringDictionary(ByteBuffer buffer) throws IOException {
        int dictionarySize = buffer.getInt();
        String[] stringDictionary = new String[dictionarySize];
        for (int i = 0; i < dictionarySize; ++i) {
            stringDictionary[i] = DataTableUtils.decodeString(buffer);
        }
        return stringDictionary;
    }

    @Override
    public void addException(ProcessingException processingException) {
        this._errCodeToExceptionMap.put(processingException.getErrorCode(), processingException.getMessage());
    }

    @Override
    public void addException(int errCode, String errMsg) {
        this._errCodeToExceptionMap.put(errCode, errMsg);
    }

    @Override
    public Map<Integer, String> getExceptions() {
        return this._errCodeToExceptionMap;
    }

    @Override
    public List<ByteBuffer> serialize() throws IOException {
        if (this._serialized == null) {
            this._serialized = DataBlockUtils.serialize(this);
        }
        return this._serialized;
    }

    public String toString() {
        if (this._dataSchema == null) {
            return "{}";
        }
        return "resultSchema:\n" + this._dataSchema + "\nnumRows: " + this._numRows + "\n";
    }

    @Override
    @Nullable
    public String[] getStringDictionary() {
        return this._stringDictionary;
    }

    @Override
    @Nullable
    public DataBuffer getFixedData() {
        return this._fixedSizeData;
    }

    @Override
    @Nullable
    public DataBuffer getVarSizeData() {
        return this._variableSizeData;
    }

    @Override
    @Nullable
    public List<DataBuffer> getStatsByStage() {
        return Collections.emptyList();
    }
}

