/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.cursors;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.BrokerResponse;
import org.apache.pinot.common.response.CursorResponse;
import org.apache.pinot.common.response.broker.CursorResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.spi.cursors.ResponseStore;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.TimeUtils;

public abstract class AbstractResponseStore
implements ResponseStore {
    protected String _brokerHost;
    protected int _brokerPort;
    protected String _brokerId;
    protected BrokerMetrics _brokerMetrics;
    protected long _expirationIntervalInMs;

    protected void init(String brokerHost, int brokerPort, String brokerId, BrokerMetrics brokerMetrics, String expirationTime) {
        this._brokerMetrics = brokerMetrics;
        this._brokerHost = brokerHost;
        this._brokerPort = brokerPort;
        this._brokerId = brokerId;
        this._expirationIntervalInMs = TimeUtils.convertPeriodToMillis((String)expirationTime);
    }

    public abstract void init(PinotConfiguration var1, String var2, int var3, String var4, BrokerMetrics var5, String var6) throws Exception;

    protected String getBrokerHost() {
        return this._brokerHost;
    }

    protected int getBrokerPort() {
        return this._brokerPort;
    }

    protected long getExpirationIntervalInMs() {
        return this._expirationIntervalInMs;
    }

    protected abstract void writeResponse(String var1, CursorResponse var2) throws Exception;

    protected abstract long writeResultTable(String var1, ResultTable var2) throws Exception;

    public abstract CursorResponse readResponse(String var1) throws Exception;

    protected abstract ResultTable readResultTable(String var1, int var2, int var3) throws Exception;

    protected abstract boolean deleteResponseImpl(String var1) throws Exception;

    public void storeResponse(BrokerResponse response) throws Exception {
        String requestId = response.getRequestId();
        CursorResponseNative cursorResponse = new CursorResponseNative(response);
        long submissionTimeMs = System.currentTimeMillis();
        cursorResponse.setBrokerHost(this.getBrokerHost());
        cursorResponse.setBrokerPort(this.getBrokerPort());
        cursorResponse.setSubmissionTimeMs(submissionTimeMs);
        cursorResponse.setExpirationTimeMs(submissionTimeMs + this.getExpirationIntervalInMs());
        cursorResponse.setOffset(0);
        cursorResponse.setNumRows(response.getNumRowsResultSet());
        try {
            long bytesWritten = this.writeResultTable(requestId, response.getResultTable());
            cursorResponse.setResultTable(null);
            cursorResponse.setBytesWritten(bytesWritten);
            this.writeResponse(requestId, cursorResponse);
            this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.CURSOR_RESPONSE_STORE_SIZE, bytesWritten);
        }
        catch (Exception e) {
            this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.CURSOR_WRITE_EXCEPTION, 1L);
            this.deleteResponse(requestId);
            throw e;
        }
    }

    public CursorResponse handleCursorRequest(String requestId, int offset, int numRows) throws Exception {
        ResultTable resultTable;
        CursorResponse response;
        try {
            response = this.readResponse(requestId);
        }
        catch (Exception e) {
            this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.CURSOR_READ_EXCEPTION, 1L);
            throw e;
        }
        int totalTableRows = response.getNumRowsResultSet();
        if (totalTableRows == 0 && offset == 0) {
            response.setResultTable(null);
            response.setOffset(0);
            response.setNumRows(0);
            return response;
        }
        if (offset >= totalTableRows) {
            throw new RuntimeException("Offset " + offset + " should be lesser than totalRecords " + totalTableRows);
        }
        long fetchStartTime = System.currentTimeMillis();
        try {
            resultTable = this.readResultTable(requestId, offset, numRows);
        }
        catch (Exception e) {
            this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.CURSOR_READ_EXCEPTION, 1L);
            throw e;
        }
        response.setResultTable(resultTable);
        response.setCursorFetchTimeMs(System.currentTimeMillis() - fetchStartTime);
        response.setOffset(offset);
        response.setNumRows(resultTable.getRows().size());
        response.setNumRowsResultSet(totalTableRows);
        return response;
    }

    public List<CursorResponse> getAllStoredResponses() throws Exception {
        ArrayList<CursorResponse> responses = new ArrayList<CursorResponse>();
        for (String requestId : this.getAllStoredRequestIds()) {
            responses.add(this.readResponse(requestId));
        }
        return responses;
    }

    public boolean deleteResponse(String requestId) throws Exception {
        if (!this.exists(requestId)) {
            return false;
        }
        long bytesWritten = this.readResponse(requestId).getBytesWritten();
        boolean isSucceeded = this.deleteResponseImpl(requestId);
        if (isSucceeded) {
            this._brokerMetrics.addMeteredGlobalValue(BrokerMeter.CURSOR_RESPONSE_STORE_SIZE, bytesWritten * -1L);
        }
        return isSucceeded;
    }
}

