/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import org.apache.pinot.spi.env.PinotConfiguration;

public class NettyConfig {
    private static final String NATIVE_TRANSPORTS_ENABLED = "native.transports.enabled";
    private boolean _nativeTransportsEnabled = false;

    private static String key(String namespace, String suffix) {
        return namespace + "." + suffix;
    }

    public static NettyConfig extractNettyConfig(PinotConfiguration pinotConfig, String namespace) {
        return NettyConfig.extractNettyConfig(pinotConfig, namespace, new NettyConfig());
    }

    public static NettyConfig extractNettyConfig(PinotConfiguration pinotConfig, String namespace, NettyConfig defaultConfig) {
        NettyConfig nettyConfig = new NettyConfig();
        nettyConfig.setNativeTransportsEnabled(pinotConfig.getProperty(NettyConfig.key(namespace, NATIVE_TRANSPORTS_ENABLED), defaultConfig.isNativeTransportsEnabled()));
        return nettyConfig;
    }

    public boolean isNativeTransportsEnabled() {
        return this._nativeTransportsEnabled;
    }

    public void setNativeTransportsEnabled(boolean nativeTransportsEnabled) {
        this._nativeTransportsEnabled = nativeTransportsEnabled;
    }
}

