/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.concurrency;

import com.google.common.base.Preconditions;
import java.util.concurrent.Semaphore;

public class AdjustableSemaphore
extends Semaphore {
    private int _totalPermits;

    public AdjustableSemaphore(int permits) {
        super(permits);
        this._totalPermits = permits;
    }

    public AdjustableSemaphore(int permits, boolean fair) {
        super(permits, fair);
        this._totalPermits = permits;
    }

    public void setPermits(int permits) {
        Preconditions.checkArgument((permits > 0 ? 1 : 0) != 0, (Object)"Permits must be a positive integer");
        if (permits < this._totalPermits) {
            this.reducePermits(this._totalPermits - permits);
        } else if (permits > this._totalPermits) {
            this.release(permits - this._totalPermits);
        }
        this._totalPermits = permits;
    }
}

