/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.collections;

import java.util.AbstractList;

public class DualValueList<E>
extends AbstractList<E> {
    private final E _firstValue;
    private final E _secondValue;
    private final int _firstCount;
    private final int _totalSize;

    public DualValueList(E firstValue, int firstCount, E secondValue, int secondCount) {
        this._firstValue = firstValue;
        this._firstCount = firstCount;
        this._secondValue = secondValue;
        this._totalSize = firstCount + secondCount;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this._totalSize) {
            throw new IndexOutOfBoundsException(index);
        }
        return index < this._firstCount ? this._firstValue : this._secondValue;
    }

    @Override
    public int size() {
        return this._totalSize;
    }
}

