/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.auth;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.pinot.common.auth.AuthConfig;
import org.apache.pinot.common.auth.BasicAuthUtils;
import org.apache.pinot.common.auth.NullAuthProvider;
import org.apache.pinot.common.auth.StaticTokenAuthProvider;
import org.apache.pinot.common.auth.UrlAuthProvider;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.env.PinotConfiguration;

public final class AuthProviderUtils {
    private AuthProviderUtils() {
    }

    public static AuthConfig extractAuthConfig(PinotConfiguration pinotConfig, String namespace) {
        if (namespace == null) {
            return new AuthConfig(pinotConfig.toMap());
        }
        return new AuthConfig(pinotConfig.subset(namespace).toMap());
    }

    public static AuthProvider extractAuthProvider(PinotConfiguration pinotConfig, String namespace) {
        if (pinotConfig == null) {
            return new NullAuthProvider();
        }
        return AuthProviderUtils.makeAuthProvider(AuthProviderUtils.extractAuthConfig(pinotConfig, namespace));
    }

    public static AuthProvider makeAuthProvider(String authToken) {
        if (StringUtils.isBlank((CharSequence)authToken)) {
            return new NullAuthProvider();
        }
        return new StaticTokenAuthProvider(authToken);
    }

    public static AuthProvider makeAuthProvider(AuthConfig authConfig) {
        if (authConfig == null) {
            return new NullAuthProvider();
        }
        Object providerClassValue = authConfig.getProperties().get("provider.class");
        if (providerClassValue != null) {
            try {
                Class<?> providerClass = Class.forName(providerClassValue.toString());
                Constructor<?> constructor = providerClass.getConstructor(AuthConfig.class);
                return (AuthProvider)constructor.newInstance(authConfig);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create AuthProvider " + providerClassValue, e);
            }
        }
        if (authConfig.getProperties().containsKey("token")) {
            return new StaticTokenAuthProvider(authConfig);
        }
        if (!authConfig.getProperties().isEmpty()) {
            throw new IllegalArgumentException("Some auth properties defined, but no provider created. Aborting.");
        }
        return new NullAuthProvider();
    }

    public static List<Header> toRequestHeaders(@Nullable Map<String, Object> headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).map(entry -> new BasicHeader((String)entry.getKey(), (Object)entry.getValue().toString())).collect(Collectors.toList());
    }

    public static List<Header> toRequestHeaders(@Nullable AuthProvider authProvider) {
        if (authProvider == null) {
            return Collections.emptyList();
        }
        return AuthProviderUtils.toRequestHeaders(authProvider.getRequestHeaders());
    }

    public static String toStaticToken(@Nullable AuthProvider authProvider) {
        if (authProvider == null) {
            return null;
        }
        return authProvider.getTaskToken();
    }

    static String getOrDefault(AuthConfig config, String key, String defaultValue) {
        if (config == null || !config.getProperties().containsKey(key)) {
            return defaultValue;
        }
        if (config.getProperties().get(key) instanceof String) {
            return (String)config.getProperties().get(key);
        }
        throw new IllegalArgumentException("Expected String but got " + config.getProperties().get(key).getClass());
    }

    public static List<Header> makeAuthHeaders(AuthProvider authProvider) {
        return AuthProviderUtils.toRequestHeaders(authProvider);
    }

    public static Map<String, String> makeAuthHeadersMap(AuthProvider authProvider) {
        if (authProvider == null) {
            return Collections.emptyMap();
        }
        return authProvider.getRequestHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }

    public static AuthProvider makeAuthProvider(@Nullable AuthProvider provider, String tokenUrl, String authToken, String user, String password) {
        if (provider != null) {
            return provider;
        }
        if (StringUtils.isNotBlank((CharSequence)tokenUrl)) {
            return new UrlAuthProvider(tokenUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)authToken)) {
            return new StaticTokenAuthProvider(authToken);
        }
        if (StringUtils.isNotBlank((CharSequence)user)) {
            return new StaticTokenAuthProvider(BasicAuthUtils.toBasicAuthToken(user, password));
        }
        return new NullAuthProvider();
    }

    public static String stripMatrixParams(String path) {
        int matrixIndex = path.indexOf(59);
        if (matrixIndex != -1) {
            return path.substring(0, matrixIndex);
        }
        return path;
    }
}

