/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class SelectionsRewriter
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        for (Expression expression : pinotQuery.getSelectList()) {
            SelectionsRewriter.tryToRewriteArrayFunction(expression);
        }
        return pinotQuery;
    }

    private static void tryToRewriteArrayFunction(Expression expression) {
        Function function = expression.getFunctionCall();
        if (function == null) {
            return;
        }
        String functionName = function.getOperator();
        List<Expression> operands = function.getOperands();
        switch (functionName) {
            case "sum": {
                if (operands.size() != 1) {
                    return;
                }
                Function innerFunction = operands.get(0).getFunctionCall();
                if (innerFunction != null && innerFunction.getOperator().equals("arraysum")) {
                    Function sumMvFunc = new Function("summv");
                    sumMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(sumMvFunc);
                }
                return;
            }
            case "min": {
                if (operands.size() != 1) {
                    return;
                }
                Function innerFunction = operands.get(0).getFunctionCall();
                if (innerFunction != null && innerFunction.getOperator().equals("arraymin")) {
                    Function minMvFunc = new Function("minmv");
                    minMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(minMvFunc);
                }
                return;
            }
            case "max": {
                if (operands.size() != 1) {
                    return;
                }
                Function innerFunction = operands.get(0).getFunctionCall();
                if (innerFunction != null && innerFunction.getOperator().equals("arraymax")) {
                    Function maxMvFunc = new Function("maxmv");
                    maxMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(maxMvFunc);
                }
                return;
            }
        }
        for (Expression operand : operands) {
            SelectionsRewriter.tryToRewriteArrayFunction(operand);
        }
    }
}

