/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class OrdinalsUpdater
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        int ordinal;
        Literal literal;
        int i;
        for (i = 0; i < pinotQuery.getGroupByListSize(); ++i) {
            Expression groupByExpr = pinotQuery.getGroupByList().get(i);
            literal = groupByExpr.getLiteral();
            if (literal == null || !literal.isSetIntValue()) continue;
            ordinal = literal.getIntValue();
            pinotQuery.getGroupByList().set(i, OrdinalsUpdater.getExpressionFromOrdinal(pinotQuery.getSelectList(), ordinal));
        }
        for (i = 0; i < pinotQuery.getOrderByListSize(); ++i) {
            Expression orderByExpr = pinotQuery.getOrderByList().get(i);
            literal = CalciteSqlParser.removeOrderByFunctions(orderByExpr).getLiteral();
            if (literal == null || !literal.isSetIntValue()) continue;
            ordinal = literal.getIntValue();
            Function functionToSet = orderByExpr.getFunctionCall();
            if (CalciteSqlParser.isNullsLast(orderByExpr) != null) {
                functionToSet = functionToSet.getOperands().get(0).getFunctionCall();
            }
            ArrayList<Expression> newOperands = new ArrayList<Expression>(1);
            newOperands.add(OrdinalsUpdater.getExpressionFromOrdinal(pinotQuery.getSelectList(), ordinal));
            functionToSet.setOperands(newOperands);
        }
        return pinotQuery;
    }

    private static Expression getExpressionFromOrdinal(List<Expression> selectList, int ordinal) {
        if (ordinal > 0 && ordinal <= selectList.size()) {
            Expression expression = selectList.get(ordinal - 1);
            if (expression.isSetFunctionCall() && expression.getFunctionCall().getOperator().equals("as")) {
                return expression.getFunctionCall().getOperands().get(0);
            }
            return expression;
        }
        throw new SqlCompilationException(String.format("Expected Ordinal value to be between 1 and %d.", selectList.size()));
    }
}

