/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.sql.FilterKind;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.SqlNodeAndOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);
    private static final JsonNode EMPTY_OBJECT_NODE = new ObjectMapper().createObjectNode();
    private static final Map<String, String> CANONICAL_NAME_TO_SPECIAL_KEY_MAP;

    private RequestUtils() {
    }

    public static SqlNodeAndOptions parseQuery(String query) throws SqlCompilationException {
        return RequestUtils.parseQuery(query, EMPTY_OBJECT_NODE);
    }

    public static SqlNodeAndOptions parseQuery(String query, JsonNode request) throws SqlCompilationException {
        long parserStartTimeNs = System.nanoTime();
        SqlNodeAndOptions sqlNodeAndOptions = CalciteSqlParser.compileToSqlNodeAndOptions(query);
        RequestUtils.setOptions(sqlNodeAndOptions, request);
        sqlNodeAndOptions.setParseTimeNs(System.nanoTime() - parserStartTimeNs);
        return sqlNodeAndOptions;
    }

    @VisibleForTesting
    public static void setOptions(SqlNodeAndOptions sqlNodeAndOptions, JsonNode jsonRequest) {
        HashMap<String, String> queryOptions = new HashMap<String, String>();
        if (jsonRequest.has("queryOptions")) {
            queryOptions.putAll(RequestUtils.getOptionsFromString(jsonRequest.get("queryOptions").asText()));
        }
        if (jsonRequest.has("trace") && jsonRequest.get("trace").asBoolean()) {
            queryOptions.put("trace", "true");
        }
        if (!queryOptions.isEmpty()) {
            LOGGER.debug("Query options are set to: {}", queryOptions);
        }
        sqlNodeAndOptions.setExtraOptions(queryOptions);
    }

    public static Expression getIdentifierExpression(String identifier) {
        Expression expression = new Expression(ExpressionType.IDENTIFIER);
        expression.setIdentifier(new Identifier(identifier));
        return expression;
    }

    public static Literal getNullLiteral() {
        return Literal.nullValue(true);
    }

    public static Literal getLiteral(boolean value) {
        return Literal.boolValue(value);
    }

    public static Literal getLiteral(int value) {
        return Literal.intValue(value);
    }

    public static Literal getLiteral(long value) {
        return Literal.longValue(value);
    }

    public static Literal getLiteral(float value) {
        return Literal.floatValue(Float.floatToRawIntBits(value));
    }

    public static Literal getLiteral(double value) {
        return Literal.doubleValue(value);
    }

    public static Literal getLiteral(BigDecimal value) {
        return Literal.bigDecimalValue(BigDecimalUtils.serialize((BigDecimal)value));
    }

    public static Literal getLiteral(String value) {
        return Literal.stringValue(value);
    }

    public static Literal getLiteral(byte[] value) {
        return Literal.binaryValue(value);
    }

    public static Literal getLiteral(int[] value) {
        return Literal.intArrayValue((List<Integer>)IntArrayList.wrap((int[])value));
    }

    public static Literal getLiteral(long[] value) {
        return Literal.longArrayValue((List<Long>)LongArrayList.wrap((long[])value));
    }

    public static Literal getLiteral(float[] value) {
        IntArrayList intBitsList = new IntArrayList(value.length);
        for (float floatValue : value) {
            intBitsList.add(Float.floatToRawIntBits(floatValue));
        }
        return Literal.floatArrayValue((List<Integer>)intBitsList);
    }

    public static Literal getLiteral(double[] value) {
        return Literal.doubleArrayValue((List<Double>)DoubleArrayList.wrap((double[])value));
    }

    public static Literal getLiteral(String[] value) {
        return Literal.stringArrayValue(Arrays.asList(value));
    }

    public static Literal getLiteral(@Nullable Object object) {
        if (object == null) {
            return RequestUtils.getNullLiteral();
        }
        if (object instanceof Boolean) {
            return RequestUtils.getLiteral((Boolean)object);
        }
        if (object instanceof Integer) {
            return RequestUtils.getLiteral((Integer)object);
        }
        if (object instanceof Long) {
            return RequestUtils.getLiteral((Long)object);
        }
        if (object instanceof Float) {
            return RequestUtils.getLiteral(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return RequestUtils.getLiteral((Double)object);
        }
        if (object instanceof BigDecimal) {
            return RequestUtils.getLiteral((BigDecimal)object);
        }
        if (object instanceof Timestamp) {
            return RequestUtils.getLiteral(((Timestamp)object).getTime());
        }
        if (object instanceof String) {
            return RequestUtils.getLiteral((String)object);
        }
        if (object instanceof byte[]) {
            return RequestUtils.getLiteral((byte[])object);
        }
        if (object instanceof int[]) {
            return RequestUtils.getLiteral((int[])object);
        }
        if (object instanceof long[]) {
            return RequestUtils.getLiteral((long[])object);
        }
        if (object instanceof float[]) {
            return RequestUtils.getLiteral((float[])object);
        }
        if (object instanceof double[]) {
            return RequestUtils.getLiteral((double[])object);
        }
        if (object instanceof String[]) {
            return RequestUtils.getLiteral((String[])object);
        }
        return RequestUtils.getLiteral(object.toString());
    }

    public static Literal getLiteral(SqlLiteral node) {
        Literal literal = new Literal();
        if (node instanceof SqlNumericLiteral) {
            BigDecimal bigDecimalValue = node.bigDecimalValue();
            assert (bigDecimalValue != null);
            SqlNumericLiteral sqlNumericLiteral = (SqlNumericLiteral)node;
            if (sqlNumericLiteral.isExact() && sqlNumericLiteral.isInteger()) {
                long longValue = bigDecimalValue.longValue();
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    literal.setIntValue((int)longValue);
                } else {
                    literal.setLongValue(longValue);
                }
            } else {
                literal.setDoubleValue(bigDecimalValue.doubleValue());
            }
        } else {
            switch (node.getTypeName()) {
                case BOOLEAN: {
                    literal.setBoolValue(node.booleanValue());
                    break;
                }
                case NULL: {
                    literal.setNullValue(true);
                    break;
                }
                default: {
                    literal.setStringValue(StringUtils.replace((String)node.toValue(), (String)"''", (String)"'"));
                }
            }
        }
        return literal;
    }

    public static Expression getLiteralExpression(Literal literal) {
        Expression expression = new Expression(ExpressionType.LITERAL);
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression getNullLiteralExpression() {
        return RequestUtils.getLiteralExpression(RequestUtils.getNullLiteral());
    }

    public static Expression getLiteralExpression(boolean value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(int value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(long value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(float value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(double value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(BigDecimal value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(String value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(byte[] value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(int[] value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(long[] value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(float[] value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(double[] value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(String[] value) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(value));
    }

    public static Expression getLiteralExpression(SqlLiteral node) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(node));
    }

    public static Expression getLiteralExpression(@Nullable Object object) {
        return RequestUtils.getLiteralExpression(RequestUtils.getLiteral(object));
    }

    @Nullable
    public static Object getLiteralValue(Literal literal) {
        Literal._Fields type = (Literal._Fields)literal.getSetField();
        switch (type) {
            case NULL_VALUE: {
                return null;
            }
            case BOOL_VALUE: {
                return literal.getBoolValue();
            }
            case INT_VALUE: {
                return literal.getIntValue();
            }
            case LONG_VALUE: {
                return literal.getLongValue();
            }
            case FLOAT_VALUE: {
                return Float.valueOf(Float.intBitsToFloat(literal.getFloatValue()));
            }
            case DOUBLE_VALUE: {
                return literal.getDoubleValue();
            }
            case BIG_DECIMAL_VALUE: {
                return BigDecimalUtils.deserialize((byte[])literal.getBigDecimalValue());
            }
            case STRING_VALUE: {
                return literal.getStringValue();
            }
            case BINARY_VALUE: {
                return literal.getBinaryValue();
            }
            case INT_ARRAY_VALUE: {
                return literal.getIntArrayValue().stream().mapToInt(Integer::intValue).toArray();
            }
            case LONG_ARRAY_VALUE: {
                return literal.getLongArrayValue().stream().mapToLong(Long::longValue).toArray();
            }
            case FLOAT_ARRAY_VALUE: {
                List<Integer> floatList = literal.getFloatArrayValue();
                int numFloats = floatList.size();
                float[] floatArray = new float[numFloats];
                for (int i = 0; i < numFloats; ++i) {
                    floatArray[i] = Float.intBitsToFloat(floatList.get(i));
                }
                return floatArray;
            }
            case DOUBLE_ARRAY_VALUE: {
                return literal.getDoubleArrayValue().stream().mapToDouble(Double::doubleValue).toArray();
            }
            case STRING_ARRAY_VALUE: {
                return literal.getStringArrayValue().toArray(new String[0]);
            }
        }
        throw new IllegalStateException("Unsupported field type: " + type);
    }

    public static String getLiteralString(Literal literal) {
        Literal._Fields type = (Literal._Fields)literal.getSetField();
        switch (type) {
            case BOOL_VALUE: {
                return Boolean.toString(literal.getBoolValue());
            }
            case INT_VALUE: {
                return Integer.toString(literal.getIntValue());
            }
            case LONG_VALUE: {
                return Long.toString(literal.getLongValue());
            }
            case FLOAT_VALUE: {
                return Float.toString(Float.intBitsToFloat(literal.getFloatValue()));
            }
            case DOUBLE_VALUE: {
                return Double.toString(literal.getDoubleValue());
            }
            case BIG_DECIMAL_VALUE: {
                return BigDecimalUtils.deserialize((byte[])literal.getBigDecimalValue()).toPlainString();
            }
            case STRING_VALUE: {
                return literal.getStringValue();
            }
            case BINARY_VALUE: {
                return BytesUtils.toHexString((byte[])literal.getBinaryValue());
            }
        }
        throw new IllegalStateException("Unsupported string representation of field type: " + type);
    }

    public static String getLiteralString(Expression expression) {
        Literal literal = expression.getLiteral();
        Preconditions.checkArgument((literal != null ? 1 : 0) != 0, (String)"Got non-literal expression: %s", (Object)expression);
        return RequestUtils.getLiteralString(literal);
    }

    public static Function getFunction(String canonicalName, List<Expression> operands) {
        Function function = new Function(canonicalName);
        function.setOperands(operands);
        return function;
    }

    public static Function getFunction(String canonicalName, Expression operand) {
        ArrayList<Expression> operands = new ArrayList<Expression>(1);
        operands.add(operand);
        return RequestUtils.getFunction(canonicalName, operands);
    }

    public static Function getFunction(String canonicalName, Expression ... operands) {
        return RequestUtils.getFunction(canonicalName, new ArrayList<Expression>(Arrays.asList(operands)));
    }

    public static Expression getFunctionExpression(Function function) {
        Expression expression = new Expression(ExpressionType.FUNCTION);
        expression.setFunctionCall(function);
        return expression;
    }

    public static Expression getFunctionExpression(String canonicalName, List<Expression> operands) {
        return RequestUtils.getFunctionExpression(RequestUtils.getFunction(canonicalName, operands));
    }

    public static Expression getFunctionExpression(String canonicalName, Expression operand) {
        return RequestUtils.getFunctionExpression(RequestUtils.getFunction(canonicalName, operand));
    }

    public static Expression getFunctionExpression(String canonicalName, Expression ... operands) {
        return RequestUtils.getFunctionExpression(RequestUtils.getFunction(canonicalName, operands));
    }

    @Deprecated
    public static Expression getFunctionExpression(String canonicalName) {
        assert (canonicalName.equalsIgnoreCase(RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(canonicalName)));
        Expression expression = new Expression(ExpressionType.FUNCTION);
        Function function = new Function(canonicalName);
        expression.setFunctionCall(function);
        return expression;
    }

    public static String canonicalizeFunctionName(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }

    public static String canonicalizeFunctionNamePreservingSpecialKey(String functionName) {
        String canonicalName = RequestUtils.canonicalizeFunctionName(functionName);
        return CANONICAL_NAME_TO_SPECIAL_KEY_MAP.getOrDefault(canonicalName, canonicalName);
    }

    public static String prettyPrint(@Nullable Expression expression) {
        if (expression == null) {
            return "null";
        }
        if (expression.getIdentifier() != null) {
            return expression.getIdentifier().getName();
        }
        if (expression.getLiteral() != null) {
            return RequestUtils.prettyPrint(expression.getLiteral());
        }
        if (expression.getFunctionCall() != null) {
            String res = expression.getFunctionCall().getOperator() + "(";
            boolean isFirstParam = true;
            for (Expression operand : expression.getFunctionCall().getOperands()) {
                if (!isFirstParam) {
                    res = res + ", ";
                } else {
                    isFirstParam = false;
                }
                res = res + RequestUtils.prettyPrint(operand);
            }
            res = res + ")";
            return res;
        }
        throw new IllegalStateException("Unsupported expression type: " + expression.getType());
    }

    public static String prettyPrint(Literal literal) {
        Literal._Fields type = (Literal._Fields)literal.getSetField();
        switch (type) {
            case NULL_VALUE: {
                return "null";
            }
            case BOOL_VALUE: {
                return Boolean.toString(literal.getBoolValue());
            }
            case INT_VALUE: {
                return Integer.toString(literal.getIntValue());
            }
            case LONG_VALUE: {
                return Long.toString(literal.getLongValue());
            }
            case FLOAT_VALUE: {
                return Float.toString(Float.intBitsToFloat(literal.getFloatValue()));
            }
            case DOUBLE_VALUE: {
                return Double.toString(literal.getDoubleValue());
            }
            case BIG_DECIMAL_VALUE: {
                return BigDecimalUtils.deserialize((byte[])literal.getBigDecimalValue()).toPlainString();
            }
            case STRING_VALUE: {
                return "'" + literal.getStringValue() + "'";
            }
            case BINARY_VALUE: {
                return "X'" + BytesUtils.toHexString((byte[])literal.getBinaryValue()) + "'";
            }
            case INT_ARRAY_VALUE: {
                return literal.getIntArrayValue().toString();
            }
            case LONG_ARRAY_VALUE: {
                return literal.getLongArrayValue().toString();
            }
            case FLOAT_ARRAY_VALUE: {
                return literal.getFloatArrayValue().stream().map(Float::intBitsToFloat).collect(Collectors.toList()).toString();
            }
            case DOUBLE_ARRAY_VALUE: {
                return literal.getDoubleArrayValue().toString();
            }
            case STRING_ARRAY_VALUE: {
                return literal.getStringArrayValue().stream().map(value -> "'" + value + "'").collect(Collectors.toList()).toString();
            }
        }
        throw new IllegalStateException("Unsupported field type: " + type);
    }

    private static Set<String> getTableNames(DataSource dataSource) {
        if (dataSource.getSubquery() != null) {
            return RequestUtils.getTableNames(dataSource.getSubquery());
        }
        if (dataSource.isSetJoin()) {
            return ImmutableSet.builder().addAll(RequestUtils.getTableNames(dataSource.getJoin().getLeft())).addAll(RequestUtils.getTableNames(dataSource.getJoin().getLeft())).build();
        }
        return ImmutableSet.of((Object)dataSource.getTableName());
    }

    public static Set<String> getTableNames(PinotQuery pinotQuery) {
        return RequestUtils.getTableNames(pinotQuery.getDataSource());
    }

    @Deprecated
    public static Map<String, String> getOptionsFromJson(JsonNode request, String optionsKey) {
        return RequestUtils.getOptionsFromString(request.get(optionsKey).asText());
    }

    public static Map<String, String> getOptionsFromString(String optionStr) {
        return Splitter.on((char)';').omitEmptyStrings().trimResults().withKeyValueSeparator('=').split((CharSequence)optionStr);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FilterKind filterKind : FilterKind.values()) {
            builder.put((Object)RequestUtils.canonicalizeFunctionName(filterKind.name()), (Object)filterKind.name());
        }
        CANONICAL_NAME_TO_SPECIAL_KEY_MAP = builder.build();
    }
}

