/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.utils.CommonConstants;

public class QueryOptionsUtils {
    private static final Map<String, String> CONFIG_RESOLVER;
    private static final RuntimeException CLASS_LOAD_ERROR;

    private QueryOptionsUtils() {
    }

    public static Map<String, String> resolveCaseInsensitiveOptions(Map<String, String> queryOptions) {
        if (CLASS_LOAD_ERROR != null) {
            throw CLASS_LOAD_ERROR;
        }
        HashMap<String, String> resolved = new HashMap<String, String>();
        for (Map.Entry<String, String> configEntry : queryOptions.entrySet()) {
            String config = CONFIG_RESOLVER.get(configEntry.getKey().toLowerCase());
            if (config != null) {
                resolved.put(config, configEntry.getValue());
                continue;
            }
            resolved.put(configEntry.getKey(), configEntry.getValue());
        }
        return resolved;
    }

    @Nullable
    public static Long getTimeoutMs(Map<String, String> queryOptions) {
        String timeoutMsString = queryOptions.get("timeoutMs");
        if (timeoutMsString != null) {
            long timeoutMs = Long.parseLong(timeoutMsString);
            Preconditions.checkState((timeoutMs > 0L ? 1 : 0) != 0, (String)"Query timeout must be positive, got: %s", (long)timeoutMs);
            return timeoutMs;
        }
        return null;
    }

    @Nullable
    public static Long getMaxServerResponseSizeBytes(Map<String, String> queryOptions) {
        String responseSize = queryOptions.get("maxServerResponseSizeBytes");
        if (responseSize != null) {
            long maxSize = Long.parseLong(responseSize);
            Preconditions.checkState((maxSize > 0L ? 1 : 0) != 0, (String)"maxServerResponseSize must be positive. got %s", (long)maxSize);
            return maxSize;
        }
        return null;
    }

    @Nullable
    public static Long getMaxQueryResponseSizeBytes(Map<String, String> queryOptions) {
        String responseSize = queryOptions.get("maxQueryResponseSizeBytes");
        if (responseSize != null) {
            long maxSize = Long.parseLong(responseSize);
            Preconditions.checkState((maxSize > 0L ? 1 : 0) != 0, (String)"maxQueryResponseSize must be positive. got %s", (long)maxSize);
            return maxSize;
        }
        return null;
    }

    public static boolean isAndScanReorderingEnabled(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("AndScanReordering"));
    }

    public static boolean isSkipUpsert(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUpsert"));
    }

    public static boolean isSkipUpsertView(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUpsertView"));
    }

    public static long getUpsertViewFreshnessMs(Map<String, String> queryOptions) {
        String freshnessMsString = queryOptions.get("upsertViewFreshnessMs");
        return freshnessMsString != null ? Long.parseLong(freshnessMsString) : -1L;
    }

    public static boolean isScanStarTreeNodes(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("scanStarTreeNodes"));
    }

    public static boolean isSkipStarTree(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useStarTree"));
    }

    public static boolean isSkipScanFilterReorder(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useScanReorderOpt"));
    }

    @Nullable
    public static Map<String, Set<FieldConfig.IndexType>> getSkipIndexes(Map<String, String> queryOptions) {
        String skipIndexesStr = queryOptions.get("skipIndexes");
        if (skipIndexesStr == null) {
            return null;
        }
        String[] perColumnIndexSkip = StringUtils.split((String)skipIndexesStr, (char)'&');
        HashMap<String, Set<FieldConfig.IndexType>> skipIndexes = new HashMap<String, Set<FieldConfig.IndexType>>();
        for (String columnConf : perColumnIndexSkip) {
            String[] indexTypes;
            String[] conf = StringUtils.split((String)columnConf, (char)'=');
            if (conf.length != 2) {
                throw new RuntimeException("Invalid format for skipIndexes. Example of valid format: SET skipIndexes='col1=inverted,range&col2=inverted'");
            }
            String columnName = conf[0];
            for (String indexType : indexTypes = StringUtils.split((String)conf[1], (char)',')) {
                skipIndexes.computeIfAbsent(columnName, k -> new HashSet()).add(FieldConfig.IndexType.valueOf((String)indexType.toUpperCase()));
            }
        }
        return skipIndexes;
    }

    @Nullable
    public static Boolean isUseFixedReplica(Map<String, String> queryOptions) {
        String useFixedReplica = queryOptions.get("useFixedReplica");
        return useFixedReplica != null ? Boolean.valueOf(Boolean.parseBoolean(useFixedReplica)) : null;
    }

    @Nullable
    public static Integer getNumReplicaGroupsToQuery(Map<String, String> queryOptions) {
        String numReplicaGroupsToQuery = queryOptions.get("numReplicaGroupsToQuery");
        return numReplicaGroupsToQuery != null ? Integer.valueOf(Integer.parseInt(numReplicaGroupsToQuery)) : null;
    }

    public static boolean isExplainPlanVerbose(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("explainPlanVerbose"));
    }

    public static boolean isUseMultistageEngine(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("useMultistageEngine"));
    }

    @Nullable
    public static Integer getMaxExecutionThreads(Map<String, String> queryOptions) {
        String maxExecutionThreadsString = queryOptions.get("maxExecutionThreads");
        return maxExecutionThreadsString != null ? Integer.valueOf(Integer.parseInt(maxExecutionThreadsString)) : null;
    }

    @Nullable
    public static Integer getMinSegmentGroupTrimSize(Map<String, String> queryOptions) {
        String minSegmentGroupTrimSizeString = queryOptions.get("minSegmentGroupTrimSize");
        return minSegmentGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minSegmentGroupTrimSizeString)) : null;
    }

    @Nullable
    public static Integer getMinServerGroupTrimSize(Map<String, String> queryOptions) {
        String minServerGroupTrimSizeString = queryOptions.get("minServerGroupTrimSize");
        return minServerGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minServerGroupTrimSizeString)) : null;
    }

    @Nullable
    public static Integer getMinBrokerGroupTrimSize(Map<String, String> queryOptions) {
        String minBrokerGroupTrimSizeString = queryOptions.get("minBrokerGroupTrimSize");
        return minBrokerGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minBrokerGroupTrimSizeString)) : null;
    }

    public static boolean isNullHandlingEnabled(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("enableNullHandling"));
    }

    public static boolean isServerReturnFinalResult(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("serverReturnFinalResult"));
    }

    public static boolean isServerReturnFinalResultKeyUnpartitioned(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("serverReturnFinalResultKeyUnpartitioned"));
    }

    @Nullable
    public static String getOrderByAlgorithm(Map<String, String> queryOptions) {
        return queryOptions.get("orderByAlgorithm");
    }

    @Nullable
    public static Integer getMultiStageLeafLimit(Map<String, String> queryOptions) {
        String maxLeafLimitStr = queryOptions.get("multiStageLeafLimit");
        return maxLeafLimitStr != null ? Integer.valueOf(Integer.parseInt(maxLeafLimitStr)) : null;
    }

    @Nullable
    public static Integer getNumGroupsLimit(Map<String, String> queryOptions) {
        String maxNumGroupLimit = queryOptions.get("numGroupsLimit");
        return maxNumGroupLimit != null ? Integer.valueOf(Integer.parseInt(maxNumGroupLimit)) : null;
    }

    @Nullable
    public static Integer getMaxInitialResultHolderCapacity(Map<String, String> queryOptions) {
        String maxInitResultCap = queryOptions.get("maxInitialResultHolderCapacity");
        return maxInitResultCap != null ? Integer.valueOf(Integer.parseInt(maxInitResultCap)) : null;
    }

    @Nullable
    public static Integer getGroupTrimThreshold(Map<String, String> queryOptions) {
        String groupByTrimThreshold = queryOptions.get("groupTrimThreshold");
        return groupByTrimThreshold != null ? Integer.valueOf(Integer.parseInt(groupByTrimThreshold)) : null;
    }

    public static boolean shouldDropResults(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("dropResults"));
    }

    @Nullable
    public static Integer getMaxStreamingPendingBlocks(Map<String, String> queryOptions) {
        String maxStreamingPendingBlocks = queryOptions.get("maxStreamingPendingBlocks");
        return maxStreamingPendingBlocks != null ? Integer.valueOf(Integer.parseInt(maxStreamingPendingBlocks)) : null;
    }

    @Nullable
    public static Integer getMaxRowsInJoin(Map<String, String> queryOptions) {
        String maxRowsInJoin = queryOptions.get("maxRowsInJoin");
        return maxRowsInJoin != null ? Integer.valueOf(Integer.parseInt(maxRowsInJoin)) : null;
    }

    @Nullable
    public static CommonConstants.MultiStageQueryRunner.JoinOverFlowMode getJoinOverflowMode(Map<String, String> queryOptions) {
        String joinOverflowModeStr = queryOptions.get("joinOverflowMode");
        return joinOverflowModeStr != null ? CommonConstants.MultiStageQueryRunner.JoinOverFlowMode.valueOf((String)joinOverflowModeStr) : null;
    }

    @Nullable
    public static Integer getMaxRowsInWindow(Map<String, String> queryOptions) {
        String maxRowsInWindow = queryOptions.get("maxRowsInWindow");
        return maxRowsInWindow != null ? Integer.valueOf(Integer.parseInt(maxRowsInWindow)) : null;
    }

    @Nullable
    public static CommonConstants.MultiStageQueryRunner.WindowOverFlowMode getWindowOverflowMode(Map<String, String> queryOptions) {
        String windowOverflowModeStr = queryOptions.get("windowOverflowMode");
        return windowOverflowModeStr != null ? CommonConstants.MultiStageQueryRunner.WindowOverFlowMode.valueOf((String)windowOverflowModeStr) : null;
    }

    public static boolean isSkipUnavailableServers(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUnavailableServers"));
    }

    static {
        HashMap<String, String> configResolver = new HashMap<String, String>();
        IllegalAccessException classLoadError = null;
        try {
            for (Field declaredField : CommonConstants.Broker.Request.QueryOptionKey.class.getDeclaredFields()) {
                int mods;
                if (!declaredField.getType().equals(String.class) || !Modifier.isStatic(mods = declaredField.getModifiers()) || !Modifier.isFinal(mods)) continue;
                String config = (String)declaredField.get(null);
                configResolver.put(config.toLowerCase(), config);
            }
        }
        catch (IllegalAccessException e) {
            configResolver = null;
            classLoadError = e;
        }
        CONFIG_RESOLVER = configResolver == null ? null : ImmutableMap.copyOf(configResolver);
        CLASS_LOAD_ERROR = classLoadError == null ? null : new RuntimeException("Failure to build case insensitive mapping.", classLoadError);
    }
}

