/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.tier;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.tier.FixedTierSegmentSelector;
import org.apache.pinot.common.tier.PinotServerTierStorage;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.tier.TierSegmentSelector;
import org.apache.pinot.common.tier.TimeBasedTierSegmentSelector;
import org.apache.pinot.spi.config.table.TierConfig;

public final class TierFactory {
    public static final String TIME_SEGMENT_SELECTOR_TYPE = "time";
    public static final String FIXED_SEGMENT_SELECTOR_TYPE = "fixed";
    public static final String PINOT_SERVER_STORAGE_TYPE = "pinot_server";

    private TierFactory() {
    }

    public static Tier getTier(TierConfig tierConfig, HelixManager helixManager) {
        TierSegmentSelector segmentSelector;
        String segmentSelectorType = tierConfig.getSegmentSelectorType();
        if (segmentSelectorType.equalsIgnoreCase(TIME_SEGMENT_SELECTOR_TYPE)) {
            segmentSelector = new TimeBasedTierSegmentSelector(helixManager, tierConfig.getSegmentAge());
        } else if (segmentSelectorType.equalsIgnoreCase(FIXED_SEGMENT_SELECTOR_TYPE)) {
            segmentSelector = new FixedTierSegmentSelector(helixManager, CollectionUtils.isEmpty((Collection)tierConfig.getSegmentList()) ? Collections.emptySet() : Sets.newHashSet((Iterable)tierConfig.getSegmentList()));
        } else {
            throw new IllegalStateException("Unsupported segmentSelectorType: " + segmentSelectorType);
        }
        String storageSelectorType = tierConfig.getStorageType();
        if (!storageSelectorType.equalsIgnoreCase(PINOT_SERVER_STORAGE_TYPE)) {
            throw new IllegalStateException("Unsupported storageType: " + storageSelectorType);
        }
        PinotServerTierStorage storageSelector = new PinotServerTierStorage(tierConfig.getServerTag(), tierConfig.getTierBackend(), tierConfig.getTierBackendProperties());
        return new Tier(tierConfig.getName(), segmentSelector, storageSelector);
    }
}

