/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.tier;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.tier.TierSegmentSelector;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class FixedTierSegmentSelector
implements TierSegmentSelector {
    private final Set<String> _segmentsToSelect;
    private final HelixManager _helixManager;

    public FixedTierSegmentSelector(HelixManager helixManager, Set<String> segmentsToSelect) {
        this._segmentsToSelect = segmentsToSelect;
        this._helixManager = helixManager;
    }

    @Override
    public String getType() {
        return "fixed";
    }

    @Override
    public boolean selectSegment(String tableNameWithType, String segmentName) {
        if (CollectionUtils.isNotEmpty(this._segmentsToSelect) && this._segmentsToSelect.contains(segmentName)) {
            if (TableType.OFFLINE == TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType)) {
                return true;
            }
            SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore<ZNRecord>)this._helixManager.getHelixPropertyStore(), tableNameWithType, segmentName);
            Preconditions.checkNotNull((Object)segmentZKMetadata, (String)"Could not find zk metadata for segment: %s of table: %s", (Object)segmentName, (Object)tableNameWithType);
            return segmentZKMetadata.getStatus().isCompleted();
        }
        return false;
    }

    public Set<String> getSegmentsToSelect() {
        return this._segmentsToSelect;
    }

    public String toString() {
        return "FixedTierSegmentSelector{_segmentsToSelect=" + this._segmentsToSelect + "}";
    }
}

