/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.pinot.common.utils.PinotStaticHttpHandler;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;

public class SwaggerSetupUtils {
    private SwaggerSetupUtils() {
    }

    public static void setupSwagger(String componentType, String resourcePackage, boolean useHttps, String basePath, HttpServer httpServer) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle(String.format("Pinot %s API", componentType));
        beanConfig.setDescription(String.format("APIs for accessing Pinot %s information", componentType));
        beanConfig.setContact("https://github.com/apache/pinot");
        beanConfig.setVersion("1.0");
        beanConfig.setExpandSuperTypes(false);
        if (useHttps) {
            beanConfig.setSchemes(new String[]{"https"});
        } else {
            beanConfig.setSchemes(new String[]{"http", "https"});
        }
        beanConfig.setBasePath(basePath);
        beanConfig.setResourcePackage(resourcePackage);
        beanConfig.setScan(true);
        ClassLoader classLoader = SwaggerSetupUtils.class.getClassLoader();
        CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(classLoader, new String[]{"/api/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/api/", "/help/"});
        URL swaggerDistLocation = classLoader.getResource("META-INF/resources/webjars/swagger-ui/5.17.14/");
        PinotStaticHttpHandler swaggerDist = new PinotStaticHttpHandler(new URLClassLoader(new URL[]{swaggerDistLocation}), new String[0]);
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)swaggerDist, new String[]{"/swaggerui-dist/"});
    }
}

