/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response.broker;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.BrokerResponse;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonPropertyOrder(value={"resultTable", "numRowsResultSet", "partialResult", "exceptions", "numGroupsLimitReached", "timeUsedMs", "requestId", "brokerId", "numDocsScanned", "totalDocs", "numEntriesScannedInFilter", "numEntriesScannedPostFilter", "numServersQueried", "numServersResponded", "numSegmentsQueried", "numSegmentsProcessed", "numSegmentsMatched", "numConsumingSegmentsQueried", "numConsumingSegmentsProcessed", "numConsumingSegmentsMatched", "minConsumingFreshnessTimeMs", "numSegmentsPrunedByBroker", "numSegmentsPrunedByServer", "numSegmentsPrunedInvalid", "numSegmentsPrunedByLimit", "numSegmentsPrunedByValue", "brokerReduceTimeMs", "offlineThreadCpuTimeNs", "realtimeThreadCpuTimeNs", "offlineSystemActivitiesCpuTimeNs", "realtimeSystemActivitiesCpuTimeNs", "offlineResponseSerializationCpuTimeNs", "realtimeResponseSerializationCpuTimeNs", "offlineTotalCpuTimeNs", "realtimeTotalCpuTimeNs", "explainPlanNumEmptyFilterSegments", "explainPlanNumMatchAllFilterSegments", "traceInfo"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class BrokerResponseNative
implements BrokerResponse {
    public static final BrokerResponseNative EMPTY_RESULT = BrokerResponseNative.empty();
    public static final BrokerResponseNative NO_TABLE_RESULT = new BrokerResponseNative(QueryException.BROKER_RESOURCE_MISSING_ERROR);
    public static final BrokerResponseNative TABLE_DOES_NOT_EXIST = new BrokerResponseNative(QueryException.TABLE_DOES_NOT_EXIST_ERROR);
    public static final BrokerResponseNative BROKER_ONLY_EXPLAIN_PLAN_OUTPUT = BrokerResponseNative.getBrokerResponseExplainPlanOutput();
    private ResultTable _resultTable;
    private int _numRowsResultSet = 0;
    private List<QueryProcessingException> _exceptions = new ArrayList<QueryProcessingException>();
    private boolean _numGroupsLimitReached = false;
    private long _timeUsedMs = 0L;
    private String _requestId;
    private String _brokerId;
    private long _numDocsScanned = 0L;
    private long _totalDocs = 0L;
    private long _numEntriesScannedInFilter = 0L;
    private long _numEntriesScannedPostFilter = 0L;
    private int _numServersQueried = 0;
    private int _numServersResponded = 0;
    private long _numSegmentsQueried = 0L;
    private long _numSegmentsProcessed = 0L;
    private long _numSegmentsMatched = 0L;
    private long _numConsumingSegmentsQueried = 0L;
    private long _numConsumingSegmentsProcessed = 0L;
    private long _numConsumingSegmentsMatched = 0L;
    private long _minConsumingFreshnessTimeMs = 0L;
    private long _numSegmentsPrunedByBroker = 0L;
    private long _numSegmentsPrunedByServer = 0L;
    private long _numSegmentsPrunedInvalid = 0L;
    private long _numSegmentsPrunedByLimit = 0L;
    private long _numSegmentsPrunedByValue = 0L;
    private long _brokerReduceTimeMs = 0L;
    private long _offlineThreadCpuTimeNs = 0L;
    private long _realtimeThreadCpuTimeNs = 0L;
    private long _offlineSystemActivitiesCpuTimeNs = 0L;
    private long _realtimeSystemActivitiesCpuTimeNs = 0L;
    private long _offlineResponseSerializationCpuTimeNs = 0L;
    private long _realtimeResponseSerializationCpuTimeNs = 0L;
    private long _explainPlanNumEmptyFilterSegments = 0L;
    private long _explainPlanNumMatchAllFilterSegments = 0L;
    private Map<String, String> _traceInfo = new HashMap<String, String>();

    public BrokerResponseNative() {
    }

    public BrokerResponseNative(ProcessingException exception) {
        this._exceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
    }

    public BrokerResponseNative(List<ProcessingException> exceptions) {
        for (ProcessingException exception : exceptions) {
            this._exceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
        }
    }

    private static BrokerResponseNative getBrokerResponseExplainPlanOutput() {
        BrokerResponseNative brokerResponse = BrokerResponseNative.empty();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"BROKER_EVALUATE", 0, -1});
        brokerResponse.setResultTable(new ResultTable(DataSchema.EXPLAIN_RESULT_SCHEMA, rows));
        return brokerResponse;
    }

    public static BrokerResponseNative empty() {
        return new BrokerResponseNative();
    }

    @VisibleForTesting
    public static BrokerResponseNative fromJsonString(String jsonString) throws IOException {
        return (BrokerResponseNative)JsonUtils.stringToObject((String)jsonString, BrokerResponseNative.class);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ResultTable getResultTable() {
        return this._resultTable;
    }

    @Override
    public void setResultTable(@Nullable ResultTable resultTable) {
        this._resultTable = resultTable;
        if (resultTable != null) {
            this._numRowsResultSet = resultTable.getRows().size();
        }
    }

    @Override
    public int getNumRowsResultSet() {
        return this._numRowsResultSet;
    }

    public void setNumRowsResultSet(int numRowsResultSet) {
        this._numRowsResultSet = numRowsResultSet;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public boolean isPartialResult() {
        return this.getExceptionsSize() > 0 || this.isNumGroupsLimitReached();
    }

    @Override
    public List<QueryProcessingException> getExceptions() {
        return this._exceptions;
    }

    public void setExceptions(List<QueryProcessingException> exceptions) {
        this._exceptions = exceptions;
    }

    public void addException(QueryProcessingException exception) {
        this._exceptions.add(exception);
    }

    public void addException(ProcessingException exception) {
        this.addException(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
    }

    @Override
    public boolean isNumGroupsLimitReached() {
        return this._numGroupsLimitReached;
    }

    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    @Override
    @JsonIgnore
    public boolean isMaxRowsInJoinReached() {
        return false;
    }

    @Override
    @JsonIgnore
    public boolean isMaxRowsInWindowReached() {
        return false;
    }

    @Override
    public long getTimeUsedMs() {
        return this._timeUsedMs;
    }

    public void setTimeUsedMs(long timeUsedMs) {
        this._timeUsedMs = timeUsedMs;
    }

    @Override
    public String getRequestId() {
        return this._requestId;
    }

    @Override
    public void setRequestId(String requestId) {
        this._requestId = requestId;
    }

    @Override
    public String getBrokerId() {
        return this._brokerId;
    }

    @Override
    public void setBrokerId(String brokerId) {
        this._brokerId = brokerId;
    }

    @Override
    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    public void setNumDocsScanned(long numDocsScanned) {
        this._numDocsScanned = numDocsScanned;
    }

    @Override
    public long getTotalDocs() {
        return this._totalDocs;
    }

    public void setTotalDocs(long totalDocs) {
        this._totalDocs = totalDocs;
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        return this._numEntriesScannedInFilter;
    }

    public void setNumEntriesScannedInFilter(long numEntriesScannedInFilter) {
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
    }

    @Override
    public long getNumEntriesScannedPostFilter() {
        return this._numEntriesScannedPostFilter;
    }

    public void setNumEntriesScannedPostFilter(long numEntriesScannedPostFilter) {
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
    }

    @Override
    public int getNumServersQueried() {
        return this._numServersQueried;
    }

    public void setNumServersQueried(int numServersQueried) {
        this._numServersQueried = numServersQueried;
    }

    @Override
    public int getNumServersResponded() {
        return this._numServersResponded;
    }

    public void setNumServersResponded(int numServersResponded) {
        this._numServersResponded = numServersResponded;
    }

    @Override
    public long getNumSegmentsQueried() {
        return this._numSegmentsQueried;
    }

    public void setNumSegmentsQueried(long numSegmentsQueried) {
        this._numSegmentsQueried = numSegmentsQueried;
    }

    @Override
    public long getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    public void setNumSegmentsProcessed(long numSegmentsProcessed) {
        this._numSegmentsProcessed = numSegmentsProcessed;
    }

    @Override
    public long getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    public void setNumSegmentsMatched(long numSegmentsMatched) {
        this._numSegmentsMatched = numSegmentsMatched;
    }

    @Override
    public long getNumConsumingSegmentsQueried() {
        return this._numConsumingSegmentsQueried;
    }

    public void setNumConsumingSegmentsQueried(long numConsumingSegmentsQueried) {
        this._numConsumingSegmentsQueried = numConsumingSegmentsQueried;
    }

    @Override
    public long getNumConsumingSegmentsProcessed() {
        return this._numConsumingSegmentsProcessed;
    }

    public void setNumConsumingSegmentsProcessed(long numConsumingSegmentsProcessed) {
        this._numConsumingSegmentsProcessed = numConsumingSegmentsProcessed;
    }

    @Override
    public long getNumConsumingSegmentsMatched() {
        return this._numConsumingSegmentsMatched;
    }

    public void setNumConsumingSegmentsMatched(long numConsumingSegmentsMatched) {
        this._numConsumingSegmentsMatched = numConsumingSegmentsMatched;
    }

    @Override
    public long getMinConsumingFreshnessTimeMs() {
        return this._minConsumingFreshnessTimeMs;
    }

    public void setMinConsumingFreshnessTimeMs(long minConsumingFreshnessTimeMs) {
        this._minConsumingFreshnessTimeMs = minConsumingFreshnessTimeMs;
    }

    @Override
    public long getNumSegmentsPrunedByBroker() {
        return this._numSegmentsPrunedByBroker;
    }

    public void setNumSegmentsPrunedByBroker(long numSegmentsPrunedByBroker) {
        this._numSegmentsPrunedByBroker = numSegmentsPrunedByBroker;
    }

    @Override
    public long getNumSegmentsPrunedByServer() {
        return this._numSegmentsPrunedByServer;
    }

    public void setNumSegmentsPrunedByServer(long numSegmentsPrunedByServer) {
        this._numSegmentsPrunedByServer = numSegmentsPrunedByServer;
    }

    @Override
    public long getNumSegmentsPrunedInvalid() {
        return this._numSegmentsPrunedInvalid;
    }

    public void setNumSegmentsPrunedInvalid(long numSegmentsPrunedInvalid) {
        this._numSegmentsPrunedInvalid = numSegmentsPrunedInvalid;
    }

    @Override
    public long getNumSegmentsPrunedByLimit() {
        return this._numSegmentsPrunedByLimit;
    }

    public void setNumSegmentsPrunedByLimit(long numSegmentsPrunedByLimit) {
        this._numSegmentsPrunedByLimit = numSegmentsPrunedByLimit;
    }

    @Override
    public long getNumSegmentsPrunedByValue() {
        return this._numSegmentsPrunedByValue;
    }

    public void setNumSegmentsPrunedByValue(long numSegmentsPrunedByValue) {
        this._numSegmentsPrunedByValue = numSegmentsPrunedByValue;
    }

    @Override
    public long getBrokerReduceTimeMs() {
        return this._brokerReduceTimeMs;
    }

    public void setBrokerReduceTimeMs(long brokerReduceTimeMs) {
        this._brokerReduceTimeMs = brokerReduceTimeMs;
    }

    @Override
    public long getOfflineThreadCpuTimeNs() {
        return this._offlineThreadCpuTimeNs;
    }

    public void setOfflineThreadCpuTimeNs(long offlineThreadCpuTimeNs) {
        this._offlineThreadCpuTimeNs = offlineThreadCpuTimeNs;
    }

    @Override
    public long getOfflineSystemActivitiesCpuTimeNs() {
        return this._offlineSystemActivitiesCpuTimeNs;
    }

    public void setOfflineSystemActivitiesCpuTimeNs(long offlineSystemActivitiesCpuTimeNs) {
        this._offlineSystemActivitiesCpuTimeNs = offlineSystemActivitiesCpuTimeNs;
    }

    @Override
    public long getOfflineResponseSerializationCpuTimeNs() {
        return this._offlineResponseSerializationCpuTimeNs;
    }

    public void setOfflineResponseSerializationCpuTimeNs(long offlineResponseSerializationCpuTimeNs) {
        this._offlineResponseSerializationCpuTimeNs = offlineResponseSerializationCpuTimeNs;
    }

    @Override
    public long getRealtimeThreadCpuTimeNs() {
        return this._realtimeThreadCpuTimeNs;
    }

    public void setRealtimeThreadCpuTimeNs(long timeUsedMs) {
        this._realtimeThreadCpuTimeNs = timeUsedMs;
    }

    @Override
    public long getRealtimeSystemActivitiesCpuTimeNs() {
        return this._realtimeSystemActivitiesCpuTimeNs;
    }

    public void setRealtimeSystemActivitiesCpuTimeNs(long realtimeSystemActivitiesCpuTimeNs) {
        this._realtimeSystemActivitiesCpuTimeNs = realtimeSystemActivitiesCpuTimeNs;
    }

    @Override
    public long getRealtimeResponseSerializationCpuTimeNs() {
        return this._realtimeResponseSerializationCpuTimeNs;
    }

    public void setRealtimeResponseSerializationCpuTimeNs(long realtimeResponseSerializationCpuTimeNs) {
        this._realtimeResponseSerializationCpuTimeNs = realtimeResponseSerializationCpuTimeNs;
    }

    @Override
    public long getExplainPlanNumEmptyFilterSegments() {
        return this._explainPlanNumEmptyFilterSegments;
    }

    public void setExplainPlanNumEmptyFilterSegments(long explainPlanNumEmptyFilterSegments) {
        this._explainPlanNumEmptyFilterSegments = explainPlanNumEmptyFilterSegments;
    }

    @Override
    public long getExplainPlanNumMatchAllFilterSegments() {
        return this._explainPlanNumMatchAllFilterSegments;
    }

    public void setExplainPlanNumMatchAllFilterSegments(long explainPlanNumMatchAllFilterSegments) {
        this._explainPlanNumMatchAllFilterSegments = explainPlanNumMatchAllFilterSegments;
    }

    @Override
    public Map<String, String> getTraceInfo() {
        return this._traceInfo;
    }

    public void setTraceInfo(Map<String, String> traceInfo) {
        this._traceInfo = traceInfo;
    }
}

