/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.lineage;

import java.util.List;
import java.util.Objects;
import org.apache.pinot.common.lineage.LineageEntryState;

public class LineageEntry {
    private final List<String> _segmentsFrom;
    private final List<String> _segmentsTo;
    private final LineageEntryState _state;
    private final long _timestamp;

    public LineageEntry(List<String> segmentsFrom, List<String> segmentsTo, LineageEntryState state, long timestamp) {
        this._segmentsFrom = segmentsFrom;
        this._segmentsTo = segmentsTo;
        this._state = state;
        this._timestamp = timestamp;
    }

    public List<String> getSegmentsFrom() {
        return this._segmentsFrom;
    }

    public List<String> getSegmentsTo() {
        return this._segmentsTo;
    }

    public LineageEntryState getState() {
        return this._state;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineageEntry that = (LineageEntry)o;
        return this._timestamp == that._timestamp && this._segmentsFrom.equals(that._segmentsFrom) && this._segmentsTo.equals(that._segmentsTo) && this._state == that._state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._segmentsFrom, this._segmentsTo, this._state, this._timestamp});
    }
}

