/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import com.google.common.base.Preconditions;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class VectorFunctions {
    private VectorFunctions() {
    }

    @ScalarFunction(names={"cosinedistance", "cosine_distance"})
    public static double cosineDistance(float[] vector1, float[] vector2) {
        return VectorFunctions.cosineDistance(vector1, vector2, Double.NaN);
    }

    @ScalarFunction(names={"cosinedistance", "cosine_distance"})
    public static double cosineDistance(float[] vector1, float[] vector2, double defaultValue) {
        VectorFunctions.validateVectors(vector1, vector2);
        double dotProduct = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            dotProduct += (double)(vector1[i] * vector2[i]);
            norm1 += Math.pow(vector1[i], 2.0);
            norm2 += Math.pow(vector2[i], 2.0);
        }
        if (norm1 == 0.0 || norm2 == 0.0) {
            return defaultValue;
        }
        return 1.0 - dotProduct / (Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    @ScalarFunction(names={"innerproduct", "inner_product"})
    public static double innerProduct(float[] vector1, float[] vector2) {
        VectorFunctions.validateVectors(vector1, vector2);
        double dotProduct = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            dotProduct += (double)(vector1[i] * vector2[i]);
        }
        return dotProduct;
    }

    @ScalarFunction(names={"l2distance", "l2_distance"})
    public static double l2Distance(float[] vector1, float[] vector2) {
        VectorFunctions.validateVectors(vector1, vector2);
        double distance = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            distance += Math.pow(vector1[i] - vector2[i], 2.0);
        }
        return Math.sqrt(distance);
    }

    @ScalarFunction(names={"l1distance", "l1_distance"})
    public static double l1Distance(float[] vector1, float[] vector2) {
        VectorFunctions.validateVectors(vector1, vector2);
        double distance = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            distance += (double)Math.abs(vector1[i] - vector2[i]);
        }
        return distance;
    }

    @ScalarFunction(names={"euclideandistance", "euclidean_distance"})
    public static double euclideanDistance(float[] vector1, float[] vector2) {
        VectorFunctions.validateVectors(vector1, vector2);
        double distance = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            distance += Math.pow(vector1[i] - vector2[i], 2.0);
        }
        return distance;
    }

    @ScalarFunction(names={"dotproduct", "dot_product"})
    public static double dotProduct(float[] vector1, float[] vector2) {
        VectorFunctions.validateVectors(vector1, vector2);
        double dotProduct = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            dotProduct += (double)(vector1[i] * vector2[i]);
        }
        return dotProduct;
    }

    @ScalarFunction(names={"vectordims", "vector_dims"})
    public static int vectorDims(float[] vector) {
        VectorFunctions.validateVector(vector);
        return vector.length;
    }

    @ScalarFunction(names={"vectornorm", "vector_norm"})
    public static double vectorNorm(float[] vector) {
        VectorFunctions.validateVector(vector);
        double norm = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            norm += Math.pow(vector[i], 2.0);
        }
        return Math.sqrt(norm);
    }

    public static void validateVectors(float[] vector1, float[] vector2) {
        Preconditions.checkArgument((vector1 != null && vector2 != null ? 1 : 0) != 0, (Object)"Null vector passed");
        Preconditions.checkArgument((vector1.length == vector2.length ? 1 : 0) != 0, (Object)"Vector lengths do not match");
    }

    public static void validateVector(float[] vector) {
        Preconditions.checkArgument((vector != null ? 1 : 0) != 0, (Object)"Null vector passed");
        Preconditions.checkArgument((vector.length > 0 ? 1 : 0) != 0, (Object)"Empty vector passed");
    }
}

