/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datatable;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.datatable.BaseDataTable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableUtils;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;

public class DataTableImplV3
extends BaseDataTable {
    private static final int HEADER_SIZE = 52;
    private final Map<Integer, String> _errCodeToExceptionMap;

    public DataTableImplV3(int numRows, DataSchema dataSchema, Map<String, Map<Integer, String>> dictionaryMap, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, dictionaryMap, fixedSizeDataBytes, variableSizeDataBytes);
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public DataTableImplV3() {
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public DataTableImplV3(ByteBuffer byteBuffer) throws IOException {
        this._numRows = byteBuffer.getInt();
        this._numColumns = byteBuffer.getInt();
        int exceptionsStart = byteBuffer.getInt();
        int exceptionsLength = byteBuffer.getInt();
        int dictionaryMapStart = byteBuffer.getInt();
        int dictionaryMapLength = byteBuffer.getInt();
        int dataSchemaStart = byteBuffer.getInt();
        int dataSchemaLength = byteBuffer.getInt();
        int fixedSizeDataStart = byteBuffer.getInt();
        int fixedSizeDataLength = byteBuffer.getInt();
        int variableSizeDataStart = byteBuffer.getInt();
        int variableSizeDataLength = byteBuffer.getInt();
        if (exceptionsLength != 0) {
            byteBuffer.position(exceptionsStart);
            this._errCodeToExceptionMap = this.deserializeExceptions(byteBuffer);
        } else {
            this._errCodeToExceptionMap = new HashMap<Integer, String>();
        }
        if (dictionaryMapLength != 0) {
            byteBuffer.position(dictionaryMapStart);
            this._dictionaryMap = this.deserializeDictionaryMap(byteBuffer);
        } else {
            this._dictionaryMap = null;
        }
        if (dataSchemaLength != 0) {
            byteBuffer.position(dataSchemaStart);
            this._dataSchema = DataSchema.fromBytes(byteBuffer);
            this._columnOffsets = new int[this._dataSchema.size()];
            this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets, this.getVersion());
        } else {
            this._dataSchema = null;
            this._columnOffsets = null;
            this._rowSizeInBytes = 0;
        }
        if (fixedSizeDataLength != 0) {
            this._fixedSizeDataBytes = new byte[fixedSizeDataLength];
            byteBuffer.position(fixedSizeDataStart);
            byteBuffer.get(this._fixedSizeDataBytes);
            this._fixedSizeData = ByteBuffer.wrap(this._fixedSizeDataBytes);
        } else {
            this._fixedSizeDataBytes = null;
            this._fixedSizeData = null;
        }
        this._variableSizeDataBytes = new byte[variableSizeDataLength];
        if (variableSizeDataLength != 0) {
            byteBuffer.position(variableSizeDataStart);
            byteBuffer.get(this._variableSizeDataBytes);
        }
        this._variableSizeData = ByteBuffer.wrap(this._variableSizeDataBytes);
        int metadataLength = byteBuffer.getInt();
        if (metadataLength != 0) {
            this._metadata = this.deserializeMetadata(byteBuffer);
        }
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public void addException(ProcessingException processingException) {
        this._errCodeToExceptionMap.put(processingException.getErrorCode(), processingException.getMessage());
    }

    @Override
    public void addException(int errCode, String errMsg) {
        this._errCodeToExceptionMap.put(errCode, errMsg);
    }

    @Override
    public Map<Integer, String> getExceptions() {
        return this._errCodeToExceptionMap;
    }

    @Override
    public byte[] toBytes() throws IOException {
        ThreadResourceUsageProvider threadResourceUsageProvider = new ThreadResourceUsageProvider();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeLeadingSections(dataOutputStream);
        if (ThreadResourceUsageProvider.isThreadCpuTimeMeasurementEnabled()) {
            long responseSerializationCpuTimeNs = threadResourceUsageProvider.getThreadTimeNs();
            this.getMetadata().put(DataTable.MetadataKey.RESPONSE_SER_CPU_TIME_NS.getName(), String.valueOf(responseSerializationCpuTimeNs));
        }
        byte[] metadataBytes = this.serializeMetadata();
        dataOutputStream.writeInt(metadataBytes.length);
        dataOutputStream.write(metadataBytes);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public DataTableImplV3 toMetadataOnlyDataTable() {
        DataTableImplV3 metadataOnlyDataTable = new DataTableImplV3();
        metadataOnlyDataTable._metadata.putAll(this._metadata);
        metadataOnlyDataTable._errCodeToExceptionMap.putAll(this._errCodeToExceptionMap);
        return metadataOnlyDataTable;
    }

    @Override
    public DataTableImplV3 toDataOnlyDataTable() {
        return new DataTableImplV3(this._numRows, this._dataSchema, this._dictionaryMap, this._fixedSizeDataBytes, this._variableSizeDataBytes);
    }

    private void writeLeadingSections(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(3);
        dataOutputStream.writeInt(this._numRows);
        dataOutputStream.writeInt(this._numColumns);
        int dataOffset = 52;
        dataOutputStream.writeInt(dataOffset);
        byte[] exceptionsBytes = this.serializeExceptions();
        dataOutputStream.writeInt(exceptionsBytes.length);
        dataOutputStream.writeInt(dataOffset += exceptionsBytes.length);
        byte[] dictionaryMapBytes = null;
        if (this._dictionaryMap != null) {
            dictionaryMapBytes = this.serializeDictionaryMap();
            dataOutputStream.writeInt(dictionaryMapBytes.length);
            dataOffset += dictionaryMapBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        byte[] dataSchemaBytes = null;
        if (this._dataSchema != null) {
            dataSchemaBytes = this._dataSchema.toBytes();
            dataOutputStream.writeInt(dataSchemaBytes.length);
            dataOffset += dataSchemaBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.writeInt(this._fixedSizeDataBytes.length);
            dataOffset += this._fixedSizeDataBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.writeInt(this._variableSizeDataBytes.length);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.write(exceptionsBytes);
        if (dictionaryMapBytes != null) {
            dataOutputStream.write(dictionaryMapBytes);
        }
        if (dataSchemaBytes != null) {
            dataOutputStream.write(dataSchemaBytes);
        }
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.write(this._fixedSizeDataBytes);
        }
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.write(this._variableSizeDataBytes);
        }
    }

    private byte[] serializeMetadata() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._metadata.size());
        for (Map.Entry entry : this._metadata.entrySet()) {
            DataTable.MetadataKey key = DataTable.MetadataKey.getByName((String)entry.getKey());
            if (key == null) continue;
            String value = (String)entry.getValue();
            dataOutputStream.writeInt(key.getId());
            if (key.getValueType() == DataTable.MetadataValueType.INT) {
                dataOutputStream.write(Ints.toByteArray((int)Integer.parseInt(value)));
                continue;
            }
            if (key.getValueType() == DataTable.MetadataValueType.LONG) {
                dataOutputStream.write(Longs.toByteArray((long)Long.parseLong(value)));
                continue;
            }
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<String, String> deserializeMetadata(ByteBuffer buffer) throws IOException {
        int numEntries = buffer.getInt();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < numEntries; ++i) {
            Object value;
            int keyId = buffer.getInt();
            DataTable.MetadataKey key = DataTable.MetadataKey.getById(keyId);
            if (key == null) continue;
            if (key.getValueType() == DataTable.MetadataValueType.INT) {
                value = "" + buffer.getInt();
                metadata.put(key.getName(), (String)value);
                continue;
            }
            if (key.getValueType() == DataTable.MetadataValueType.LONG) {
                value = "" + buffer.getLong();
                metadata.put(key.getName(), (String)value);
                continue;
            }
            value = DataTableUtils.decodeString(buffer);
            metadata.put(key.getName(), (String)value);
        }
        return metadata;
    }

    private byte[] serializeExceptions() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._errCodeToExceptionMap.size());
        for (Map.Entry<Integer, String> entry : this._errCodeToExceptionMap.entrySet()) {
            int key = entry.getKey();
            String value = entry.getValue();
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(key);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<Integer, String> deserializeExceptions(ByteBuffer buffer) throws IOException {
        int numExceptions = buffer.getInt();
        HashMap<Integer, String> exceptions = new HashMap<Integer, String>(HashUtil.getHashMapCapacity(numExceptions));
        for (int i = 0; i < numExceptions; ++i) {
            int errCode = buffer.getInt();
            String errMessage = DataTableUtils.decodeString(buffer);
            exceptions.put(errCode, errMessage);
        }
        return exceptions;
    }
}

